/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ResourceProcessDefinitionUtils {
    public static Map<Integer, Set<Long>> getResourceProcessDefinitionMap(List<Map<String, Object>> resourceList) {
        HashMap<Integer, Set<Long>> resourceResult = new HashMap<Integer, Set<Long>>();
        if (CollectionUtils.isNotEmpty(resourceList)) {
            for (Map<String, Object> resourceMap : resourceList) {
                Long code = (Long)resourceMap.get("code");
                String[] resourceIds = ((String)resourceMap.get("resource_ids")).split(",");
                Set resourceIdSet = Arrays.stream(resourceIds).map(Integer::parseInt).collect(Collectors.toSet());
                for (Integer resourceId : resourceIdSet) {
                    Set codeSet = resourceResult.containsKey(resourceId) ? (Set)resourceResult.get(resourceId) : new HashSet();
                    codeSet.add(code);
                    resourceResult.put(resourceId, codeSet);
                }
            }
        }
        return resourceResult;
    }
}

