/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ProcessExecutionTypeEnum;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;

@TableName(value="t_ds_process_definition")
public class ProcessDefinition {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    private long code;
    private String name;
    private int version;
    private ReleaseState releaseState;
    private long projectCode;
    private String description;
    private String globalParams;
    @TableField(exist=false)
    private List<Property> globalParamList;
    @TableField(exist=false)
    private Map<String, String> globalParamMap;
    private Date createTime;
    private Date updateTime;
    private Flag flag;
    private int userId;
    @TableField(exist=false)
    private String userName;
    @TableField(exist=false)
    private String projectName;
    private String locations;
    @TableField(exist=false)
    private ReleaseState scheduleReleaseState;
    private int timeout;
    private int tenantId;
    @TableField(exist=false)
    private String tenantCode;
    @TableField(exist=false)
    private String modifyBy;
    @TableField(exist=false)
    private Integer warningGroupId;
    private ProcessExecutionTypeEnum executionType;

    public ProcessDefinition() {
    }

    public ProcessDefinition(long projectCode, String name, long code, String description, String globalParams, String locations, int timeout, int userId, int tenantId) {
        Date date;
        this.set(projectCode, name, description, globalParams, locations, timeout, tenantId);
        this.code = code;
        this.userId = userId;
        this.createTime = date = new Date();
        this.updateTime = date;
    }

    public void set(long projectCode, String name, String description, String globalParams, String locations, int timeout, int tenantId) {
        this.projectCode = projectCode;
        this.name = name;
        this.description = description;
        this.globalParams = globalParams;
        this.locations = locations;
        this.timeout = timeout;
        this.tenantId = tenantId;
        this.flag = Flag.YES;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ReleaseState getReleaseState() {
        return this.releaseState;
    }

    public void setReleaseState(ReleaseState releaseState) {
        this.releaseState = releaseState;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getGlobalParams() {
        return this.globalParams;
    }

    public void setGlobalParams(String globalParams) {
        this.globalParamList = JSONUtils.toList((String)globalParams, Property.class);
        if (this.globalParamList == null) {
            this.globalParamList = new ArrayList<Property>();
        }
        this.globalParams = globalParams;
    }

    public List<Property> getGlobalParamList() {
        return this.globalParamList;
    }

    public void setGlobalParamList(List<Property> globalParamList) {
        this.globalParamList = globalParamList;
    }

    public Map<String, String> getGlobalParamMap() {
        if (this.globalParamMap == null && StringUtils.isNotEmpty((String)this.globalParams)) {
            List propList = JSONUtils.toList((String)this.globalParams, Property.class);
            this.globalParamMap = propList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        }
        return this.globalParamMap;
    }

    public void setGlobalParamMap(Map<String, String> globalParamMap) {
        this.globalParamMap = globalParamMap;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String locations) {
        this.locations = locations;
    }

    public ReleaseState getScheduleReleaseState() {
        return this.scheduleReleaseState;
    }

    public void setScheduleReleaseState(ReleaseState scheduleReleaseState) {
        this.scheduleReleaseState = scheduleReleaseState;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModifyBy() {
        return this.modifyBy;
    }

    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    public Integer getWarningGroupId() {
        return this.warningGroupId;
    }

    public void setWarningGroupId(Integer warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    public ProcessExecutionTypeEnum getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(ProcessExecutionTypeEnum executionType) {
        this.executionType = executionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDefinition that = (ProcessDefinition)o;
        return this.projectCode == that.projectCode && this.userId == that.userId && this.timeout == that.timeout && this.tenantId == that.tenantId && Objects.equals(this.name, that.name) && this.releaseState == that.releaseState && Objects.equals(this.description, that.description) && Objects.equals(this.globalParams, that.globalParams) && this.flag == that.flag && this.executionType == that.executionType && Objects.equals(this.locations, that.locations);
    }

    public String toString() {
        return "ProcessDefinition{id=" + this.id + ", code=" + this.code + ", name='" + this.name + '\'' + ", version=" + this.version + ", releaseState=" + this.releaseState + ", projectCode=" + this.projectCode + ", description='" + this.description + '\'' + ", globalParams='" + this.globalParams + '\'' + ", globalParamList=" + this.globalParamList + ", globalParamMap=" + this.globalParamMap + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", flag=" + this.flag + ", userId=" + this.userId + ", userName='" + this.userName + '\'' + ", projectName='" + this.projectName + '\'' + ", locations='" + this.locations + '\'' + ", scheduleReleaseState=" + this.scheduleReleaseState + ", timeout=" + this.timeout + ", tenantId=" + this.tenantId + ", tenantCode='" + this.tenantCode + '\'' + ", modifyBy='" + this.modifyBy + '\'' + ", warningGroupId=" + this.warningGroupId + '}';
    }
}

