/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;

@TableName(value="t_ds_command")
public class Command {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    @TableField(value="command_type")
    private CommandType commandType;
    @TableField(value="process_definition_code")
    private long processDefinitionCode;
    @TableField(value="executor_id")
    private int executorId;
    @TableField(value="command_param")
    private String commandParam;
    @TableField(value="task_depend_type")
    private TaskDependType taskDependType;
    @TableField(value="failure_strategy")
    private FailureStrategy failureStrategy;
    @TableField(value="warning_type")
    private WarningType warningType;
    @TableField(value="warning_group_id")
    private Integer warningGroupId;
    @TableField(value="schedule_time")
    private Date scheduleTime;
    @TableField(value="start_time")
    private Date startTime;
    @TableField(value="process_instance_priority")
    private Priority processInstancePriority;
    @TableField(value="update_time")
    private Date updateTime;
    @TableField(value="worker_group")
    private String workerGroup;
    @TableField(value="environment_code")
    private Long environmentCode;
    @TableField(value="dry_run")
    private int dryRun;
    @TableField(value="process_instance_id")
    private int processInstanceId;
    @TableField(value="process_definition_version")
    private int processDefinitionVersion;

    public Command() {
        this.taskDependType = TaskDependType.TASK_POST;
        this.failureStrategy = FailureStrategy.CONTINUE;
        this.startTime = new Date();
        this.updateTime = new Date();
    }

    public Command(CommandType commandType, TaskDependType taskDependType, FailureStrategy failureStrategy, int executorId, long processDefinitionCode, String commandParam, WarningType warningType, int warningGroupId, Date scheduleTime, String workerGroup, Long environmentCode, Priority processInstancePriority, int dryRun, int processInstanceId, int processDefinitionVersion) {
        this.commandType = commandType;
        this.executorId = executorId;
        this.processDefinitionCode = processDefinitionCode;
        this.commandParam = commandParam;
        this.warningType = warningType;
        this.warningGroupId = warningGroupId;
        this.scheduleTime = scheduleTime;
        this.taskDependType = taskDependType;
        this.failureStrategy = failureStrategy;
        this.startTime = new Date();
        this.updateTime = new Date();
        this.workerGroup = workerGroup;
        this.environmentCode = environmentCode;
        this.processInstancePriority = processInstancePriority;
        this.dryRun = dryRun;
        this.processInstanceId = processInstanceId;
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public TaskDependType getTaskDependType() {
        return this.taskDependType;
    }

    public void setTaskDependType(TaskDependType taskDependType) {
        this.taskDependType = taskDependType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public long getProcessDefinitionCode() {
        return this.processDefinitionCode;
    }

    public void setProcessDefinitionCode(long processDefinitionCode) {
        this.processDefinitionCode = processDefinitionCode;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void setFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    public void setCommandParam(String commandParam) {
        this.commandParam = commandParam;
    }

    public String getCommandParam() {
        return this.commandParam;
    }

    public WarningType getWarningType() {
        return this.warningType;
    }

    public void setWarningType(WarningType warningType) {
        this.warningType = warningType;
    }

    public Integer getWarningGroupId() {
        return this.warningGroupId;
    }

    public void setWarningGroupId(Integer warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public void setExecutorId(int executorId) {
        this.executorId = executorId;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public Long getEnvironmentCode() {
        return this.environmentCode;
    }

    public void setEnvironmentCode(Long environmentCode) {
        this.environmentCode = environmentCode;
    }

    public int getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(int dryRun) {
        this.dryRun = dryRun;
    }

    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command command = (Command)o;
        if (this.id != command.id) {
            return false;
        }
        if (this.processDefinitionCode != command.processDefinitionCode) {
            return false;
        }
        if (this.executorId != command.executorId) {
            return false;
        }
        if (this.workerGroup != null ? this.workerGroup.equals(command.workerGroup) : command.workerGroup == null) {
            return false;
        }
        if (this.environmentCode != null ? this.environmentCode.equals(command.environmentCode) : command.environmentCode == null) {
            return false;
        }
        if (this.commandType != command.commandType) {
            return false;
        }
        if (this.commandParam != null ? !this.commandParam.equals(command.commandParam) : command.commandParam != null) {
            return false;
        }
        if (this.taskDependType != command.taskDependType) {
            return false;
        }
        if (this.failureStrategy != command.failureStrategy) {
            return false;
        }
        if (this.warningType != command.warningType) {
            return false;
        }
        if (this.warningGroupId != null ? !this.warningGroupId.equals(command.warningGroupId) : command.warningGroupId != null) {
            return false;
        }
        if (this.scheduleTime != null ? !this.scheduleTime.equals(command.scheduleTime) : command.scheduleTime != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(command.startTime) : command.startTime != null) {
            return false;
        }
        if (this.processInstancePriority != command.processInstancePriority) {
            return false;
        }
        if (this.processInstanceId != command.processInstanceId) {
            return false;
        }
        if (this.processDefinitionVersion != command.getProcessDefinitionVersion()) {
            return false;
        }
        return !(this.updateTime == null ? command.updateTime != null : !this.updateTime.equals(command.updateTime));
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.commandType != null ? this.commandType.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.processDefinitionCode);
        result = 31 * result + this.executorId;
        result = 31 * result + (this.commandParam != null ? this.commandParam.hashCode() : 0);
        result = 31 * result + (this.taskDependType != null ? this.taskDependType.hashCode() : 0);
        result = 31 * result + (this.failureStrategy != null ? this.failureStrategy.hashCode() : 0);
        result = 31 * result + (this.warningType != null ? this.warningType.hashCode() : 0);
        result = 31 * result + (this.warningGroupId != null ? this.warningGroupId.hashCode() : 0);
        result = 31 * result + (this.scheduleTime != null ? this.scheduleTime.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.processInstancePriority != null ? this.processInstancePriority.hashCode() : 0);
        result = 31 * result + (this.updateTime != null ? this.updateTime.hashCode() : 0);
        result = 31 * result + (this.workerGroup != null ? this.workerGroup.hashCode() : 0);
        result = 31 * result + (this.environmentCode != null ? this.environmentCode.hashCode() : 0);
        result = 31 * result + this.dryRun;
        result = 31 * result + this.processInstanceId;
        result = 31 * result + this.processDefinitionVersion;
        return result;
    }

    public String toString() {
        return "Command{id=" + this.id + ", commandType=" + this.commandType + ", processDefinitionCode=" + this.processDefinitionCode + ", executorId=" + this.executorId + ", commandParam='" + this.commandParam + '\'' + ", taskDependType=" + this.taskDependType + ", failureStrategy=" + this.failureStrategy + ", warningType=" + this.warningType + ", warningGroupId=" + this.warningGroupId + ", scheduleTime=" + this.scheduleTime + ", startTime=" + this.startTime + ", processInstancePriority=" + this.processInstancePriority + ", updateTime=" + this.updateTime + ", workerGroup='" + this.workerGroup + '\'' + ", environmentCode='" + this.environmentCode + '\'' + ", dryRun='" + this.dryRun + '\'' + ", processInstanceId='" + this.processInstanceId + '\'' + ", processDefinitionVersion='" + this.processDefinitionVersion + '\'' + '}';
    }
}

