/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import java.util.List;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;

public class DependentProcessDefinition {
    private long processDefinitionCode;
    private String processDefinitionName;
    private int processDefinitionVersion;
    private long taskDefinitionCode;
    private String taskParams;
    private String workerGroup;

    public CycleEnum getDependentCycle(long upstreamProcessDefinitionCode) {
        DependentParameters dependentParameters = this.getDependentParameters();
        List dependentTaskModelList = dependentParameters.getDependTaskList();
        for (DependentTaskModel dependentTaskModel : dependentTaskModelList) {
            List dependentItemList = dependentTaskModel.getDependItemList();
            for (DependentItem dependentItem : dependentItemList) {
                if (upstreamProcessDefinitionCode != dependentItem.getDefinitionCode()) continue;
                return this.cycle2CycleEnum(dependentItem.getCycle());
            }
        }
        return CycleEnum.DAY;
    }

    public CycleEnum cycle2CycleEnum(String cycle) {
        CycleEnum cycleEnum = null;
        switch (cycle) {
            case "day": {
                cycleEnum = CycleEnum.DAY;
                break;
            }
            case "hour": {
                cycleEnum = CycleEnum.HOUR;
                break;
            }
            case "week": {
                cycleEnum = CycleEnum.WEEK;
                break;
            }
            case "month": {
                cycleEnum = CycleEnum.MONTH;
                break;
            }
        }
        return cycleEnum;
    }

    public DependentParameters getDependentParameters() {
        return (DependentParameters)JSONUtils.parseObject((String)this.getDependence(), DependentParameters.class);
    }

    public String getDependence() {
        return JSONUtils.getNodeString((String)this.taskParams, (String)"dependence");
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String name) {
        this.processDefinitionName = name;
    }

    public long getProcessDefinitionCode() {
        return this.processDefinitionCode;
    }

    public void setProcessDefinitionCode(long code) {
        this.processDefinitionCode = code;
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public long getTaskDefinitionCode() {
        return this.taskDefinitionCode;
    }

    public void setTaskDefinitionCode(long code) {
        this.taskDefinitionCode = code;
    }

    public String getTaskParams() {
        return this.taskParams;
    }

    public void setTaskParams(String taskParams) {
        this.taskParams = taskParams;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }
}

