/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.dao.repository.IDao;

public abstract class BaseDao<ENTITY, MYBATIS_MAPPER extends BaseMapper<ENTITY>>
implements IDao<ENTITY> {
    protected MYBATIS_MAPPER mybatisMapper;

    public BaseDao(@NonNull MYBATIS_MAPPER mybatisMapper) {
        if (mybatisMapper == null) {
            throw new NullPointerException("mybatisMapper is marked non-null but is null");
        }
        this.mybatisMapper = mybatisMapper;
    }

    @Override
    public ENTITY queryById(@NonNull Serializable id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return (ENTITY)this.mybatisMapper.selectById(id);
    }

    @Override
    public Optional<ENTITY> queryOptionalById(@NonNull Serializable id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Optional.ofNullable(this.queryById(id));
    }

    @Override
    public List<ENTITY> queryByIds(Collection<? extends Serializable> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.mybatisMapper.selectBatchIds(ids);
    }

    @Override
    public int insert(@NonNull ENTITY model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return this.mybatisMapper.insert(model);
    }

    @Override
    public void insertBatch(Collection<ENTITY> models) {
        if (CollectionUtils.isEmpty(models)) {
            return;
        }
        for (ENTITY model : models) {
            this.insert(model);
        }
    }

    @Override
    public boolean updateById(@NonNull ENTITY model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return this.mybatisMapper.updateById(model) > 0;
    }

    @Override
    public boolean deleteById(@NonNull Serializable id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.mybatisMapper.deleteById(id) > 0;
    }

    @Override
    public boolean deleteByIds(Collection<? extends Serializable> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return true;
        }
        return this.mybatisMapper.deleteBatchIds(ids) > 0;
    }
}

