/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ProcessInstanceDaoImpl
extends BaseDao<ProcessInstance, ProcessInstanceMapper>
implements ProcessInstanceDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceDaoImpl.class);
    @Autowired
    private ProcessInstanceMapMapper processInstanceMapMapper;

    public ProcessInstanceDaoImpl(@NonNull ProcessInstanceMapper processInstanceMapper) {
        super(processInstanceMapper);
        if (processInstanceMapper == null) {
            throw new NullPointerException("processInstanceMapper is marked non-null but is null");
        }
    }

    @Override
    public void upsertProcessInstance(@NonNull ProcessInstance processInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (processInstance.getId() != null) {
            this.updateById(processInstance);
        } else {
            this.insert(processInstance);
        }
    }

    @Override
    public ProcessInstance queryLastSchedulerProcessInterval(Long definitionCode, DateInterval dateInterval, int testFlag) {
        return ((ProcessInstanceMapper)this.mybatisMapper).queryLastSchedulerProcess(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime(), testFlag);
    }

    @Override
    public ProcessInstance queryLastManualProcessInterval(Long definitionCode, DateInterval dateInterval, int testFlag) {
        return ((ProcessInstanceMapper)this.mybatisMapper).queryLastManualProcess(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime(), testFlag);
    }

    @Override
    public ProcessInstance queryFirstScheduleProcessInstance(Long definitionCode) {
        return ((ProcessInstanceMapper)this.mybatisMapper).queryFirstScheduleProcessInstance(definitionCode);
    }

    @Override
    public ProcessInstance queryFirstStartProcessInstance(Long definitionCode) {
        return ((ProcessInstanceMapper)this.mybatisMapper).queryFirstStartProcessInstance(definitionCode);
    }

    @Override
    public ProcessInstance querySubProcessInstanceByParentId(Integer processInstanceId, Integer taskInstanceId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryByParentId(processInstanceId, taskInstanceId);
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = (ProcessInstance)this.queryById(Integer.valueOf(processInstanceMap.getProcessInstanceId()));
        return processInstance;
    }
}

