/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduleDao.class);

    public Map<Integer, Long> queryAllSchedule(Connection conn) {
        HashMap<Integer, Long> scheduleMap = new HashMap<Integer, Long>();
        String sql = "SELECT id,process_definition_code FROM t_ds_schedules";
        try (PreparedStatement pstmt = conn.prepareStatement(sql);
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                Integer id = rs.getInt(1);
                long processDefinitionCode = rs.getLong(2);
                scheduleMap.put(id, processDefinitionCode);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql: " + sql, e);
        }
        return scheduleMap;
    }

    public void updateScheduleCode(Connection conn, Map<Integer, Long> scheduleMap, Map<Integer, Long> processIdCodeMap) {
        String sql = "UPDATE t_ds_schedules SET process_definition_code=?,timezone_id=?,environment_code=-1 where id=?";
        try {
            Clock clock = Clock.systemDefaultZone();
            String timezoneId = clock.getZone().getId();
            for (Map.Entry<Integer, Long> entry : scheduleMap.entrySet()) {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    Integer projectDefinitionId;
                    long projectDefinitionCode = entry.getValue();
                    if (String.valueOf(projectDefinitionCode).length() <= 10 && processIdCodeMap.containsKey(projectDefinitionId = Integer.valueOf(Integer.parseInt(String.valueOf(projectDefinitionCode))))) {
                        projectDefinitionCode = processIdCodeMap.get(projectDefinitionId);
                    }
                    pstmt.setLong(1, projectDefinitionCode);
                    pstmt.setString(2, timezoneId);
                    pstmt.setInt(3, entry.getKey());
                    pstmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql: " + sql, e);
        }
    }
}

