/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.MonitorRecord;
import org.apache.dolphinscheduler.dao.utils.BaseDBPerformance;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Performance
extends BaseDBPerformance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2Performance.class);

    @Override
    public MonitorRecord getMonitorRecord(Connection conn) {
        MonitorRecord monitorRecord = new MonitorRecord();
        monitorRecord.setDate(new Date());
        monitorRecord.setDbType(DbType.H2);
        monitorRecord.setState(Flag.YES);
        try (Statement pstmt = conn.createStatement();
             ResultSet rs1 = pstmt.executeQuery("select count(1) as total from information_schema.sessions;");){
            if (rs1.next()) {
                monitorRecord.setThreadsConnections(rs1.getInt("total"));
            }
        }
        catch (SQLException e) {
            monitorRecord.setState(Flag.NO);
            log.error("SQLException ", (Throwable)e);
        }
        return monitorRecord;
    }
}

