/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.MonitorRecord;
import org.apache.dolphinscheduler.dao.utils.BaseDBPerformance;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLPerformance
extends BaseDBPerformance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLPerformance.class);

    @Override
    public MonitorRecord getMonitorRecord(Connection conn) {
        MonitorRecord monitorRecord = new MonitorRecord();
        monitorRecord.setDate(new Date());
        monitorRecord.setDbType(DbType.MYSQL);
        monitorRecord.setState(Flag.YES);
        try (Statement pstmt = conn.createStatement();){
            try (ResultSet rs1 = pstmt.executeQuery("show global variables");){
                while (rs1.next()) {
                    if (!"MAX_CONNECTIONS".equalsIgnoreCase(rs1.getString("variable_name"))) continue;
                    monitorRecord.setMaxConnections(Long.parseLong(rs1.getString("value")));
                }
            }
            var6_9 = null;
            try (ResultSet rs2 = pstmt.executeQuery("show global status");){
                while (rs2.next()) {
                    if ("MAX_USED_CONNECTIONS".equalsIgnoreCase(rs2.getString("variable_name"))) {
                        monitorRecord.setMaxUsedConnections(Long.parseLong(rs2.getString("value")));
                        continue;
                    }
                    if ("THREADS_CONNECTED".equalsIgnoreCase(rs2.getString("variable_name"))) {
                        monitorRecord.setThreadsConnections(Long.parseLong(rs2.getString("value")));
                        continue;
                    }
                    if (!"THREADS_RUNNING".equalsIgnoreCase(rs2.getString("variable_name"))) continue;
                    monitorRecord.setThreadsRunningConnections(Long.parseLong(rs2.getString("value")));
                }
            }
            catch (Throwable throwable) {
                var6_9 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            monitorRecord.setState(Flag.NO);
            log.error("SQLException ", (Throwable)e);
        }
        return monitorRecord;
    }
}

