/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;

@TableName(value="t_ds_task_definition")
public class TaskDefinition {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    private long code;
    private String name;
    private int version;
    private String description;
    private long projectCode;
    private int userId;
    private String taskType;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String taskParams;
    @TableField(exist=false)
    private List<Property> taskParamList;
    @TableField(exist=false)
    private Map<String, String> taskParamMap;
    private Flag flag;
    private Flag isCache;
    private Priority taskPriority;
    @TableField(exist=false)
    private String userName;
    @TableField(exist=false)
    private String projectName;
    private String workerGroup;
    private long environmentCode;
    private int failRetryTimes;
    private int failRetryInterval;
    private TimeoutFlag timeoutFlag;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private TaskTimeoutStrategy timeoutNotifyStrategy;
    private int timeout;
    private int delayTime;
    @Deprecated
    private String resourceIds;
    private Date createTime;
    private Date updateTime;
    @TableField(exist=false)
    private String modifyBy;
    private int taskGroupId;
    private int taskGroupPriority;
    private Integer cpuQuota;
    private Integer memoryMax;
    private TaskExecuteType taskExecuteType;

    public TaskDefinition() {
    }

    public TaskDefinition(long code, int version) {
        this.code = code;
        this.version = version;
    }

    public List<Property> getTaskParamList() {
        JsonNode localParams = JSONUtils.parseObject((String)this.taskParams).findValue("localParams");
        if (localParams != null) {
            this.taskParamList = JSONUtils.toList((String)localParams.toString(), Property.class);
        }
        return this.taskParamList;
    }

    public Map<String, String> getTaskParamMap() {
        List propList;
        JsonNode localParams;
        if (this.taskParamMap == null && !Strings.isNullOrEmpty((String)this.taskParams) && (localParams = JSONUtils.parseObject((String)this.taskParams).findValue("localParams")) != null && !localParams.isNull() && CollectionUtils.isNotEmpty((Collection)(propList = JSONUtils.toList((String)localParams.toString(), Property.class)))) {
            this.taskParamMap = new HashMap<String, String>();
            for (Property property : propList) {
                this.taskParamMap.put(property.getProp(), property.getValue());
            }
        }
        return this.taskParamMap;
    }

    public String getDependence() {
        return JSONUtils.getNodeString((String)this.taskParams, (String)"dependence");
    }

    public Integer getCpuQuota() {
        return this.cpuQuota == null ? -1 : this.cpuQuota;
    }

    public Integer getMemoryMax() {
        return this.memoryMax == null ? -1 : this.memoryMax;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        TaskDefinition that = (TaskDefinition)o;
        return this.failRetryTimes == that.failRetryTimes && this.failRetryInterval == that.failRetryInterval && this.timeout == that.timeout && this.delayTime == that.delayTime && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.taskType, that.taskType) && Objects.equals(this.taskParams, that.taskParams) && this.flag == that.flag && this.isCache == that.isCache && this.taskPriority == that.taskPriority && Objects.equals(this.workerGroup, that.workerGroup) && this.timeoutFlag == that.timeoutFlag && this.timeoutNotifyStrategy == that.timeoutNotifyStrategy && (Objects.equals(this.resourceIds, that.resourceIds) || "".equals(this.resourceIds) && that.resourceIds == null || "".equals(that.resourceIds) && this.resourceIds == null) && this.environmentCode == that.environmentCode && this.taskGroupId == that.taskGroupId && this.taskGroupPriority == that.taskGroupPriority && Objects.equals(this.cpuQuota, that.cpuQuota) && Objects.equals(this.memoryMax, that.memoryMax) && Objects.equals(this.taskExecuteType, that.taskExecuteType);
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public long getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public long getProjectCode() {
        return this.projectCode;
    }

    @Generated
    public int getUserId() {
        return this.userId;
    }

    @Generated
    public String getTaskType() {
        return this.taskType;
    }

    @Generated
    public String getTaskParams() {
        return this.taskParams;
    }

    @Generated
    public Flag getFlag() {
        return this.flag;
    }

    @Generated
    public Flag getIsCache() {
        return this.isCache;
    }

    @Generated
    public Priority getTaskPriority() {
        return this.taskPriority;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public long getEnvironmentCode() {
        return this.environmentCode;
    }

    @Generated
    public int getFailRetryTimes() {
        return this.failRetryTimes;
    }

    @Generated
    public int getFailRetryInterval() {
        return this.failRetryInterval;
    }

    @Generated
    public TimeoutFlag getTimeoutFlag() {
        return this.timeoutFlag;
    }

    @Generated
    public TaskTimeoutStrategy getTimeoutNotifyStrategy() {
        return this.timeoutNotifyStrategy;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getDelayTime() {
        return this.delayTime;
    }

    @Deprecated
    @Generated
    public String getResourceIds() {
        return this.resourceIds;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getModifyBy() {
        return this.modifyBy;
    }

    @Generated
    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    @Generated
    public int getTaskGroupPriority() {
        return this.taskGroupPriority;
    }

    @Generated
    public TaskExecuteType getTaskExecuteType() {
        return this.taskExecuteType;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setCode(long code) {
        this.code = code;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(int version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    @Generated
    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Generated
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @Generated
    public void setTaskParams(String taskParams) {
        this.taskParams = taskParams;
    }

    @Generated
    public void setTaskParamList(List<Property> taskParamList) {
        this.taskParamList = taskParamList;
    }

    @Generated
    public void setTaskParamMap(Map<String, String> taskParamMap) {
        this.taskParamMap = taskParamMap;
    }

    @Generated
    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    @Generated
    public void setIsCache(Flag isCache) {
        this.isCache = isCache;
    }

    @Generated
    public void setTaskPriority(Priority taskPriority) {
        this.taskPriority = taskPriority;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Generated
    public void setEnvironmentCode(long environmentCode) {
        this.environmentCode = environmentCode;
    }

    @Generated
    public void setFailRetryTimes(int failRetryTimes) {
        this.failRetryTimes = failRetryTimes;
    }

    @Generated
    public void setFailRetryInterval(int failRetryInterval) {
        this.failRetryInterval = failRetryInterval;
    }

    @Generated
    public void setTimeoutFlag(TimeoutFlag timeoutFlag) {
        this.timeoutFlag = timeoutFlag;
    }

    @Generated
    public void setTimeoutNotifyStrategy(TaskTimeoutStrategy timeoutNotifyStrategy) {
        this.timeoutNotifyStrategy = timeoutNotifyStrategy;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    @Deprecated
    @Generated
    public void setResourceIds(String resourceIds) {
        this.resourceIds = resourceIds;
    }

    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    @Generated
    public void setTaskGroupId(int taskGroupId) {
        this.taskGroupId = taskGroupId;
    }

    @Generated
    public void setTaskGroupPriority(int taskGroupPriority) {
        this.taskGroupPriority = taskGroupPriority;
    }

    @Generated
    public void setCpuQuota(Integer cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    @Generated
    public void setMemoryMax(Integer memoryMax) {
        this.memoryMax = memoryMax;
    }

    @Generated
    public void setTaskExecuteType(TaskExecuteType taskExecuteType) {
        this.taskExecuteType = taskExecuteType;
    }

    @Generated
    public String toString() {
        return "TaskDefinition(id=" + this.getId() + ", code=" + this.getCode() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", projectCode=" + this.getProjectCode() + ", userId=" + this.getUserId() + ", taskType=" + this.getTaskType() + ", taskParams=" + this.getTaskParams() + ", taskParamList=" + this.getTaskParamList() + ", taskParamMap=" + this.getTaskParamMap() + ", flag=" + this.getFlag() + ", isCache=" + this.getIsCache() + ", taskPriority=" + this.getTaskPriority() + ", userName=" + this.getUserName() + ", projectName=" + this.getProjectName() + ", workerGroup=" + this.getWorkerGroup() + ", environmentCode=" + this.getEnvironmentCode() + ", failRetryTimes=" + this.getFailRetryTimes() + ", failRetryInterval=" + this.getFailRetryInterval() + ", timeoutFlag=" + this.getTimeoutFlag() + ", timeoutNotifyStrategy=" + this.getTimeoutNotifyStrategy() + ", timeout=" + this.getTimeout() + ", delayTime=" + this.getDelayTime() + ", resourceIds=" + this.getResourceIds() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", modifyBy=" + this.getModifyBy() + ", taskGroupId=" + this.getTaskGroupId() + ", taskGroupPriority=" + this.getTaskGroupPriority() + ", cpuQuota=" + this.getCpuQuota() + ", memoryMax=" + this.getMemoryMax() + ", taskExecuteType=" + this.getTaskExecuteType() + ")";
    }
}

