/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.builder;

import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.DataQualityTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;

public class TaskExecutionContextBuilder {
    private TaskExecutionContext taskExecutionContext = new TaskExecutionContext();

    public static TaskExecutionContextBuilder get() {
        return new TaskExecutionContextBuilder();
    }

    public TaskExecutionContextBuilder buildTaskInstanceRelatedInfo(TaskInstance taskInstance) {
        this.taskExecutionContext.setTaskInstanceId(taskInstance.getId());
        this.taskExecutionContext.setTaskName(taskInstance.getName());
        this.taskExecutionContext.setFirstSubmitTime(taskInstance.getFirstSubmitTime());
        this.taskExecutionContext.setStartTime(taskInstance.getStartTime());
        this.taskExecutionContext.setTaskType(taskInstance.getTaskType());
        this.taskExecutionContext.setLogPath(taskInstance.getLogPath());
        this.taskExecutionContext.setWorkerGroup(taskInstance.getWorkerGroup());
        this.taskExecutionContext.setEnvironmentConfig(taskInstance.getEnvironmentConfig());
        this.taskExecutionContext.setHost(taskInstance.getHost());
        this.taskExecutionContext.setResources(taskInstance.getResources());
        this.taskExecutionContext.setDelayTime(taskInstance.getDelayTime());
        this.taskExecutionContext.setVarPool(taskInstance.getVarPool());
        this.taskExecutionContext.setDryRun(taskInstance.getDryRun());
        return this;
    }

    public TaskExecutionContextBuilder buildTaskDefinitionRelatedInfo(TaskDefinition taskDefinition) {
        this.taskExecutionContext.setTaskTimeout(Integer.MAX_VALUE);
        if (taskDefinition.getTimeoutFlag() == TimeoutFlag.OPEN) {
            this.taskExecutionContext.setTaskTimeoutStrategy(taskDefinition.getTimeoutNotifyStrategy());
            if (taskDefinition.getTimeoutNotifyStrategy() == TaskTimeoutStrategy.FAILED || taskDefinition.getTimeoutNotifyStrategy() == TaskTimeoutStrategy.WARNFAILED) {
                this.taskExecutionContext.setTaskTimeout(Math.min(taskDefinition.getTimeout() * 60, Integer.MAX_VALUE));
            }
        }
        this.taskExecutionContext.setTaskParams(taskDefinition.getTaskParams());
        return this;
    }

    public TaskExecutionContextBuilder buildProcessInstanceRelatedInfo(ProcessInstance processInstance) {
        this.taskExecutionContext.setProcessInstanceId(processInstance.getId());
        this.taskExecutionContext.setScheduleTime(processInstance.getScheduleTime());
        this.taskExecutionContext.setGlobalParams(processInstance.getGlobalParams());
        this.taskExecutionContext.setExecutorId(processInstance.getExecutorId());
        this.taskExecutionContext.setCmdTypeIfComplement(processInstance.getCmdTypeIfComplement().getCode());
        this.taskExecutionContext.setTenantCode(processInstance.getTenantCode());
        this.taskExecutionContext.setQueue(processInstance.getQueue());
        return this;
    }

    public TaskExecutionContextBuilder buildProcessDefinitionRelatedInfo(ProcessDefinition processDefinition) {
        this.taskExecutionContext.setProcessDefineCode(Long.valueOf(processDefinition.getCode()));
        this.taskExecutionContext.setProcessDefineVersion(processDefinition.getVersion());
        this.taskExecutionContext.setProjectCode(processDefinition.getProjectCode());
        return this;
    }

    public TaskExecutionContextBuilder buildDataQualityTaskExecutionContext(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        this.taskExecutionContext.setDataQualityTaskExecutionContext(dataQualityTaskExecutionContext);
        return this;
    }

    public TaskExecutionContextBuilder buildResourceParametersInfo(ResourceParametersHelper parametersHelper) {
        this.taskExecutionContext.setResourceParametersHelper(parametersHelper);
        return this;
    }

    public TaskExecutionContext create() {
        return this.taskExecutionContext;
    }
}

