/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.auto.service.AutoService;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.remote.command.TaskKillRequestCommand;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.enums.ExecutorType;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.ExecuteException;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.queue.TaskPriority;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueueImpl;

@AutoService(value={ITaskProcessor.class})
public class CommonTaskProcessor
extends BaseTaskProcessor {
    private TaskPriorityQueue taskUpdateQueue;
    private NettyExecutorManager nettyExecutorManager = (NettyExecutorManager)SpringApplicationContext.getBean(NettyExecutorManager.class);

    @Override
    protected boolean submitTask() {
        boolean acquireTaskGroup;
        this.taskInstance = this.processService.submitTaskWithRetry(this.processInstance, this.taskInstance, this.maxRetryTimes, this.commitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        int taskGroupId = this.taskInstance.getTaskGroupId();
        if (taskGroupId > 0 && !(acquireTaskGroup = this.processService.acquireTaskGroup(this.taskInstance.getId(), this.taskInstance.getName(), taskGroupId, this.taskInstance.getProcessInstanceId(), this.taskInstance.getTaskInstancePriority().getCode()))) {
            this.logger.info("submit task name :{}, but the first time to try to acquire task group failed", (Object)this.taskInstance.getName());
            return true;
        }
        this.dispatchTask();
        return true;
    }

    @Override
    public boolean runTask() {
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        return true;
    }

    @Override
    protected boolean pauseTask() {
        return true;
    }

    @Override
    public String getType() {
        return "common";
    }

    @Override
    public boolean dispatchTask() {
        try {
            if (this.taskUpdateQueue == null) {
                this.initQueue();
            }
            if (this.taskInstance.getState().typeIsFinished()) {
                this.logger.info(String.format("submit task , but task [%s] state [%s] is already  finished. ", this.taskInstance.getName(), this.taskInstance.getState().toString()));
                return true;
            }
            if (this.taskInstance.getState() == ExecutionStatus.RUNNING_EXECUTION || this.taskInstance.getState() == ExecutionStatus.DELAY_EXECUTION) {
                this.logger.info("submit task, but the status of the task {} is already running or delayed.", (Object)this.taskInstance.getName());
                return true;
            }
            this.logger.info("task ready to submit: {}", (Object)this.taskInstance);
            TaskPriority taskPriority = new TaskPriority(this.processInstance.getProcessInstancePriority().getCode(), this.processInstance.getId(), this.taskInstance.getProcessInstancePriority().getCode(), this.taskInstance.getId(), "default");
            TaskExecutionContext taskExecutionContext = this.getTaskExecutionContext(this.taskInstance);
            taskPriority.setTaskExecutionContext(taskExecutionContext);
            this.taskUpdateQueue.put((Object)taskPriority);
            this.logger.info(String.format("master submit success, task : %s", this.taskInstance.getName()));
            return true;
        }
        catch (Exception e) {
            this.logger.error("submit task error", (Throwable)e);
            return false;
        }
    }

    public void initQueue() {
        this.taskUpdateQueue = (TaskPriorityQueue)SpringApplicationContext.getBean(TaskPriorityQueueImpl.class);
    }

    @Override
    public boolean killTask() {
        try {
            this.taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
            if (this.taskInstance == null) {
                return true;
            }
            if (this.taskInstance.getState().typeIsFinished()) {
                return true;
            }
            if (StringUtils.isBlank((String)this.taskInstance.getHost())) {
                this.taskInstance.setState(ExecutionStatus.KILL);
                this.taskInstance.setEndTime(new Date());
                this.processService.updateTaskInstance(this.taskInstance);
                return true;
            }
            TaskKillRequestCommand killCommand = new TaskKillRequestCommand();
            killCommand.setTaskInstanceId(this.taskInstance.getId());
            ExecutionContext executionContext = new ExecutionContext(killCommand.convert2Command(), ExecutorType.WORKER);
            Host host = Host.of((String)this.taskInstance.getHost());
            executionContext.setHost(host);
            this.nettyExecutorManager.executeDirectly(executionContext);
        }
        catch (ExecuteException e) {
            this.logger.error("kill task error:", (Throwable)e);
            return false;
        }
        this.logger.info("master kill taskInstance name :{} taskInstance id:{}", (Object)this.taskInstance.getName(), (Object)this.taskInstance.getId());
        return true;
    }
}

