/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqRule;
import org.apache.dolphinscheduler.dao.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.plugin.task.api.DataQualityTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.ConnectorType;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.ExecuteSqlType;
import org.apache.dolphinscheduler.plugin.task.api.model.JdbcInfo;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.AbstractResourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.UdfFuncParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.JdbcUrlParser;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.dq.DataQualityParameters;
import org.apache.dolphinscheduler.server.builder.TaskExecutionContextBuilder;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskProcessor
implements ITaskProcessor {
    protected final Logger logger = LoggerFactory.getLogger((String)String.format("TaskLogLogger-%s", this.getClass()));
    protected boolean killed = false;
    protected boolean paused = false;
    protected boolean timeout = false;
    protected TaskInstance taskInstance = null;
    protected ProcessInstance processInstance;
    protected int maxRetryTimes;
    protected int commitInterval;
    protected ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);
    protected MasterConfig masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
    protected TaskPluginManager taskPluginManager = (TaskPluginManager)SpringApplicationContext.getBean(TaskPluginManager.class);
    protected String threadLoggerInfoName;
    protected javax.sql.DataSource defaultDataSource = (javax.sql.DataSource)SpringApplicationContext.getBean(javax.sql.DataSource.class);

    @Override
    public void init(TaskInstance taskInstance, ProcessInstance processInstance) {
        if (this.processService == null) {
            this.processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);
        }
        if (this.masterConfig == null) {
            this.masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
        }
        this.taskInstance = taskInstance;
        this.processInstance = processInstance;
        this.maxRetryTimes = this.masterConfig.getTaskCommitRetryTimes();
        this.commitInterval = this.masterConfig.getTaskCommitInterval();
    }

    protected abstract boolean pauseTask();

    protected abstract boolean killTask();

    protected abstract boolean taskTimeout();

    protected abstract boolean submitTask();

    protected abstract boolean runTask();

    protected abstract boolean dispatchTask();

    @Override
    public boolean action(TaskAction taskAction) {
        String threadName = Thread.currentThread().getName();
        if (StringUtils.isNotEmpty((CharSequence)this.threadLoggerInfoName)) {
            Thread.currentThread().setName(this.threadLoggerInfoName);
        }
        switch (taskAction) {
            case STOP: {
                return this.stop();
            }
            case PAUSE: {
                return this.pause();
            }
            case TIMEOUT: {
                return this.timeout();
            }
            case SUBMIT: {
                return this.submit();
            }
            case RUN: {
                return this.run();
            }
            case DISPATCH: {
                return this.dispatch();
            }
        }
        this.logger.error("unknown task action: {}", (Object)taskAction);
        Thread.currentThread().setName(threadName);
        return false;
    }

    protected boolean submit() {
        return this.submitTask();
    }

    protected boolean run() {
        return this.runTask();
    }

    protected boolean dispatch() {
        return this.dispatchTask();
    }

    protected boolean timeout() {
        if (this.timeout) {
            return true;
        }
        this.timeout = this.taskTimeout();
        return this.timeout;
    }

    protected boolean pause() {
        if (this.paused) {
            return true;
        }
        this.paused = this.pauseTask();
        return this.paused;
    }

    protected boolean stop() {
        if (this.killed) {
            return true;
        }
        this.killed = this.killTask();
        return this.killed;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public TaskInstance taskInstance() {
        return this.taskInstance;
    }

    public void setTaskExecutionLogger() {
        this.threadLoggerInfoName = LoggerUtils.buildTaskId((Date)this.taskInstance.getFirstSubmitTime(), (Long)this.processInstance.getProcessDefinitionCode(), (int)this.processInstance.getProcessDefinitionVersion(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId());
        Thread.currentThread().setName(this.threadLoggerInfoName);
    }

    protected TaskExecutionContext getTaskExecutionContext(TaskInstance taskInstance) {
        int userId = taskInstance.getProcessDefine() == null ? 0 : taskInstance.getProcessDefine().getUserId();
        Tenant tenant = this.processService.getTenantForProcess(taskInstance.getProcessInstance().getTenantId(), userId);
        if (this.verifyTenantIsNull(tenant, taskInstance)) {
            taskInstance.setState(ExecutionStatus.FAILURE);
            this.processService.saveTaskInstance(taskInstance);
            return null;
        }
        String userQueue = this.processService.queryUserQueueByProcessInstance(taskInstance.getProcessInstance());
        taskInstance.getProcessInstance().setQueue(StringUtils.isEmpty((CharSequence)userQueue) ? tenant.getQueue() : userQueue);
        taskInstance.getProcessInstance().setTenantCode(tenant.getTenantCode());
        taskInstance.setResources(this.getResourceFullNames(taskInstance));
        TaskChannel taskChannel = this.taskPluginManager.getTaskChannel(taskInstance.getTaskType());
        ResourceParametersHelper resources = taskChannel.getResources(taskInstance.getTaskParams());
        this.setTaskResourceInfo(resources);
        DataQualityTaskExecutionContext dataQualityTaskExecutionContext = new DataQualityTaskExecutionContext();
        if ("DATA_QUALITY".equalsIgnoreCase(taskInstance.getTaskType())) {
            this.setDataQualityTaskRelation(dataQualityTaskExecutionContext, taskInstance, tenant.getTenantCode());
        }
        return TaskExecutionContextBuilder.get().buildTaskInstanceRelatedInfo(taskInstance).buildTaskDefinitionRelatedInfo(taskInstance.getTaskDefine()).buildProcessInstanceRelatedInfo(taskInstance.getProcessInstance()).buildProcessDefinitionRelatedInfo(taskInstance.getProcessDefine()).buildResourceParametersInfo(resources).buildDataQualityTaskExecutionContext(dataQualityTaskExecutionContext).create();
    }

    private void setTaskResourceInfo(ResourceParametersHelper resourceParametersHelper) {
        if (Objects.isNull(resourceParametersHelper)) {
            return;
        }
        resourceParametersHelper.getResourceMap().forEach((type, map) -> {
            switch (type) {
                case DATASOURCE: {
                    this.setTaskDataSourceResourceInfo((Map<Integer, AbstractResourceParameters>)map);
                    break;
                }
                case UDF: {
                    this.setTaskUdfFuncResourceInfo((Map<Integer, AbstractResourceParameters>)map);
                    break;
                }
            }
        });
    }

    private void setTaskDataSourceResourceInfo(Map<Integer, AbstractResourceParameters> map) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        map.forEach((code, parameters) -> {
            DataSource datasource = this.processService.findDataSourceById(code.intValue());
            if (Objects.isNull(datasource)) {
                return;
            }
            DataSourceParameters dataSourceParameters = new DataSourceParameters();
            dataSourceParameters.setType(datasource.getType());
            dataSourceParameters.setConnectionParams(datasource.getConnectionParams());
            map.put((Integer)code, (AbstractResourceParameters)dataSourceParameters);
        });
    }

    private void setTaskUdfFuncResourceInfo(Map<Integer, AbstractResourceParameters> map) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        List udfFuncList = this.processService.queryUdfFunListByIds(map.keySet().toArray(new Integer[map.size()]));
        udfFuncList.forEach(udfFunc -> {
            UdfFuncParameters udfFuncParameters = (UdfFuncParameters)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)udfFunc), UdfFuncParameters.class);
            udfFuncParameters.setDefaultFS(HadoopUtils.getInstance().getDefaultFS());
            String tenantCode = this.processService.queryTenantCodeByResName(udfFunc.getResourceName(), ResourceType.UDF);
            udfFuncParameters.setTenantCode(tenantCode);
            map.put(udfFunc.getId(), (AbstractResourceParameters)udfFuncParameters);
        });
    }

    private void setDataQualityTaskRelation(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, TaskInstance taskInstance, String tenantCode) {
        DataQualityParameters dataQualityParameters = (DataQualityParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), DataQualityParameters.class);
        if (dataQualityParameters == null) {
            return;
        }
        Map config = dataQualityParameters.getRuleInputParameter();
        int ruleId = dataQualityParameters.getRuleId();
        DqRule dqRule = this.processService.getDqRule(ruleId);
        if (dqRule == null) {
            this.logger.error("can not get DqRule by id {}", (Object)ruleId);
            return;
        }
        dataQualityTaskExecutionContext.setRuleId(ruleId);
        dataQualityTaskExecutionContext.setRuleType(dqRule.getType());
        dataQualityTaskExecutionContext.setRuleName(dqRule.getName());
        List ruleInputEntryList = this.processService.getRuleInputEntry(ruleId);
        if (CollectionUtils.isEmpty((Collection)ruleInputEntryList)) {
            this.logger.error("{} rule input entry list is empty ", (Object)ruleId);
            return;
        }
        List executeSqlList = this.processService.getDqExecuteSql(ruleId);
        this.setComparisonParams(dataQualityTaskExecutionContext, config, ruleInputEntryList, executeSqlList);
        dataQualityTaskExecutionContext.setRuleInputEntryList(JSONUtils.toJsonString((Object)ruleInputEntryList));
        dataQualityTaskExecutionContext.setExecuteSqlList(JSONUtils.toJsonString((Object)executeSqlList));
        dataQualityTaskExecutionContext.setHdfsPath(PropertyUtils.getString((String)"fs.defaultFS") + PropertyUtils.getString((String)"data-quality.error.output.path", (String)("/user/" + tenantCode + "/data_quality_error_data")));
        this.setSourceConfig(dataQualityTaskExecutionContext, config);
        this.setTargetConfig(dataQualityTaskExecutionContext, config);
        this.setWriterConfig(dataQualityTaskExecutionContext);
        this.setStatisticsValueWriterConfig(dataQualityTaskExecutionContext);
    }

    private void setComparisonParams(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, Map<String, String> config, List<DqRuleInputEntry> ruleInputEntryList, List<DqRuleExecuteSql> executeSqlList) {
        if (config.get("comparison_type") != null) {
            int comparisonTypeId = Integer.parseInt(config.get("comparison_type"));
            if (comparisonTypeId > 1) {
                DqComparisonType type = this.processService.getComparisonTypeById(comparisonTypeId);
                if (type != null) {
                    DqRuleInputEntry comparisonName = new DqRuleInputEntry();
                    comparisonName.setField("comparison_name");
                    comparisonName.setValue(type.getName());
                    ruleInputEntryList.add(comparisonName);
                    DqRuleInputEntry comparisonTable = new DqRuleInputEntry();
                    comparisonTable.setField("comparison_table");
                    comparisonTable.setValue(type.getOutputTable());
                    ruleInputEntryList.add(comparisonTable);
                    if (executeSqlList == null) {
                        executeSqlList = new ArrayList<DqRuleExecuteSql>();
                    }
                    DqRuleExecuteSql dqRuleExecuteSql = new DqRuleExecuteSql();
                    dqRuleExecuteSql.setType(ExecuteSqlType.MIDDLE.getCode());
                    dqRuleExecuteSql.setIndex(1);
                    dqRuleExecuteSql.setSql(type.getExecuteSql());
                    dqRuleExecuteSql.setTableAlias(type.getOutputTable());
                    executeSqlList.add(0, dqRuleExecuteSql);
                    if (Boolean.TRUE.equals(type.getInnerSource())) {
                        dataQualityTaskExecutionContext.setComparisonNeedStatisticsValueTable(true);
                    }
                }
            } else if (comparisonTypeId == 1) {
                dataQualityTaskExecutionContext.setCompareWithFixedValue(true);
            }
        }
    }

    public DataSource getDefaultDataSource() {
        DataSource dataSource = new DataSource();
        HikariDataSource hikariDataSource = (HikariDataSource)this.defaultDataSource;
        dataSource.setUserName(hikariDataSource.getUsername());
        JdbcInfo jdbcInfo = JdbcUrlParser.getJdbcInfo((String)hikariDataSource.getJdbcUrl());
        if (jdbcInfo != null) {
            Properties properties = new Properties();
            properties.setProperty("user", hikariDataSource.getUsername());
            properties.setProperty("password", hikariDataSource.getPassword());
            properties.setProperty("database", jdbcInfo.getDatabase());
            properties.setProperty("address", jdbcInfo.getAddress());
            properties.setProperty("other", jdbcInfo.getParams());
            properties.setProperty("jdbcUrl", jdbcInfo.getAddress() + "/" + jdbcInfo.getDatabase());
            dataSource.setType(DbType.of((int)JdbcUrlParser.getDbType((String)jdbcInfo.getDriverName()).getCode()));
            dataSource.setConnectionParams(JSONUtils.toJsonString((Object)properties));
        }
        return dataSource;
    }

    private void setStatisticsValueWriterConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        DataSource dataSource = this.getDefaultDataSource();
        ConnectorType writerConnectorType = ConnectorType.of((Integer)(dataSource.getType().isHive() ? 1 : 0));
        dataQualityTaskExecutionContext.setStatisticsValueConnectorType(writerConnectorType.getDescription());
        dataQualityTaskExecutionContext.setStatisticsValueType(dataSource.getType().getCode());
        dataQualityTaskExecutionContext.setStatisticsValueWriterConnectionParams(dataSource.getConnectionParams());
        dataQualityTaskExecutionContext.setStatisticsValueTable("t_ds_dq_task_statistics_value");
    }

    private void setWriterConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        DataSource dataSource = this.getDefaultDataSource();
        ConnectorType writerConnectorType = ConnectorType.of((Integer)(dataSource.getType().isHive() ? 1 : 0));
        dataQualityTaskExecutionContext.setWriterConnectorType(writerConnectorType.getDescription());
        dataQualityTaskExecutionContext.setWriterType(dataSource.getType().getCode());
        dataQualityTaskExecutionContext.setWriterConnectionParams(dataSource.getConnectionParams());
        dataQualityTaskExecutionContext.setWriterTable("t_ds_dq_execute_result");
    }

    private void setTargetConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, Map<String, String> config) {
        DataSource dataSource;
        if (StringUtils.isNotEmpty((CharSequence)config.get("target_datasource_id")) && (dataSource = this.processService.findDataSourceById(Integer.parseInt(config.get("target_datasource_id")))) != null) {
            ConnectorType targetConnectorType = ConnectorType.of((Integer)(DbType.of((int)Integer.parseInt(config.get("target_connector_type"))).isHive() ? 1 : 0));
            dataQualityTaskExecutionContext.setTargetConnectorType(targetConnectorType.getDescription());
            dataQualityTaskExecutionContext.setTargetType(dataSource.getType().getCode());
            dataQualityTaskExecutionContext.setTargetConnectionParams(dataSource.getConnectionParams());
        }
    }

    private void setSourceConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, Map<String, String> config) {
        DataSource dataSource;
        if (StringUtils.isNotEmpty((CharSequence)config.get("src_datasource_id")) && (dataSource = this.processService.findDataSourceById(Integer.parseInt(config.get("src_datasource_id")))) != null) {
            ConnectorType srcConnectorType = ConnectorType.of((Integer)(DbType.of((int)Integer.parseInt(config.get("src_connector_type"))).isHive() ? 1 : 0));
            dataQualityTaskExecutionContext.setSourceConnectorType(srcConnectorType.getDescription());
            dataQualityTaskExecutionContext.setSourceType(dataSource.getType().getCode());
            dataQualityTaskExecutionContext.setSourceConnectionParams(dataSource.getConnectionParams());
        }
    }

    protected boolean verifyTenantIsNull(Tenant tenant, TaskInstance taskInstance) {
        if (tenant == null) {
            this.logger.error("tenant not exists,process instance id : {},task instance id : {}", (Object)taskInstance.getProcessInstance().getId(), (Object)taskInstance.getId());
            return true;
        }
        return false;
    }

    protected Map<String, String> getResourceFullNames(TaskInstance taskInstance) {
        List projectResourceFiles;
        HashMap<String, String> resourcesMap = new HashMap<String, String>();
        AbstractParameters baseParam = this.taskPluginManager.getParameters(ParametersNode.builder().taskType(taskInstance.getTaskType()).taskParams(taskInstance.getTaskParams()).build());
        if (baseParam != null && CollectionUtils.isNotEmpty((Collection)(projectResourceFiles = baseParam.getResourceFilesList()))) {
            Stream<Integer> resourceIdStream;
            Set<Integer> resourceIdsSet;
            Set<ResourceInfo> oldVersionResources = projectResourceFiles.stream().filter(t -> t.getId() == 0).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(oldVersionResources)) {
                oldVersionResources.forEach(t -> resourcesMap.put(t.getRes(), this.processService.queryTenantCodeByResName(t.getRes(), ResourceType.FILE)));
            }
            if (CollectionUtils.isNotEmpty(resourceIdsSet = (resourceIdStream = projectResourceFiles.stream().map(ResourceInfo::getId)).collect(Collectors.toSet()))) {
                Integer[] resourceIds = resourceIdsSet.toArray(new Integer[resourceIdsSet.size()]);
                List resources = this.processService.listResourceByIds(resourceIds);
                resources.forEach(t -> resourcesMap.put(t.getFullName(), this.processService.queryTenantCodeByResName(t.getFullName(), ResourceType.FILE)));
            }
        }
        return resourcesMap;
    }
}

