/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master;

import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.log.LoggerRequestProcessor;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.processor.CacheProcessor;
import org.apache.dolphinscheduler.server.master.processor.StateEventProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskEventProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskExecuteResponseProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskExecuteRunningProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskKillResponseProcessor;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.server.master.runner.EventExecuteService;
import org.apache.dolphinscheduler.server.master.runner.FailoverExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.MasterSchedulerService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@ComponentScan(value={"org.apache.dolphinscheduler"})
@EnableTransactionManagement
@EnableCaching
public class MasterServer
implements IStoppable {
    private static final Logger logger = LoggerFactory.getLogger(MasterServer.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private SpringApplicationContext springApplicationContext;
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private MasterRegistryClient masterRegistryClient;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private MasterSchedulerService masterSchedulerService;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private TaskExecuteRunningProcessor taskExecuteRunningProcessor;
    @Autowired
    private TaskExecuteResponseProcessor taskExecuteResponseProcessor;
    @Autowired
    private TaskEventProcessor taskEventProcessor;
    @Autowired
    private StateEventProcessor stateEventProcessor;
    @Autowired
    private CacheProcessor cacheProcessor;
    @Autowired
    private TaskKillResponseProcessor taskKillResponseProcessor;
    @Autowired
    private EventExecuteService eventExecuteService;
    @Autowired
    private FailoverExecuteThread failoverExecuteThread;
    @Autowired
    private LoggerRequestProcessor loggerRequestProcessor;

    public static void main(String[] args) {
        Thread.currentThread().setName("Master-Server");
        SpringApplication.run(MasterServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void run() throws SchedulerException {
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.masterConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RESPONSE, (NettyRequestProcessor)this.taskExecuteResponseProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RUNNING, (NettyRequestProcessor)this.taskExecuteRunningProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_RESPONSE, (NettyRequestProcessor)this.taskKillResponseProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.STATE_EVENT_REQUEST, (NettyRequestProcessor)this.stateEventProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_FORCE_STATE_EVENT_REQUEST, (NettyRequestProcessor)this.taskEventProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_WAKEUP_EVENT_REQUEST, (NettyRequestProcessor)this.taskEventProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.CACHE_EXPIRE, (NettyRequestProcessor)this.cacheProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.GET_LOG_BYTES_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.ROLL_VIEW_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.VIEW_WHOLE_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.REMOVE_TAK_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.start();
        this.taskPluginManager.installPlugin();
        this.masterRegistryClient.init();
        this.masterRegistryClient.start();
        this.masterRegistryClient.setRegistryStoppable(this);
        this.masterSchedulerService.init();
        this.masterSchedulerService.start();
        this.eventExecuteService.start();
        this.failoverExecuteThread.start();
        this.scheduler.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Stopper.isRunning()) {
                this.close("shutdownHook");
            }
        }));
    }

    public void close(String cause) {
        try {
            if (Stopper.isStopped()) {
                return;
            }
            logger.info("master server is stopping ..., cause : {}", (Object)cause);
            Stopper.stop();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception ", (Throwable)e);
            }
            this.masterSchedulerService.close();
            this.nettyRemotingServer.close();
            this.masterRegistryClient.closeRegistry();
            this.springApplicationContext.close();
        }
        catch (Exception e) {
            logger.error("master server stop exception ", (Throwable)e);
        }
    }

    public void stop(String cause) {
        this.close(cause);
    }
}

