/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteResponseProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteResponseProcessor.class);
    @Autowired
    private TaskEventService taskEventService;

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_RESPONSE == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteResponseCommand taskExecuteResponseCommand = (TaskExecuteResponseCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskExecuteResponseCommand.class);
        this.logger.info("received command : {}", (Object)taskExecuteResponseCommand);
        TaskEvent taskResponseEvent = TaskEvent.newResultEvent(taskExecuteResponseCommand, channel);
        this.taskEventService.addEvent(taskResponseEvent);
    }
}

