/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventExecuteService
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(EventExecuteService.class);
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;

    @Override
    public synchronized void start() {
        super.setName("EventServiceStarted");
        super.start();
    }

    @Override
    public void run() {
        logger.info("Event service started");
        while (Stopper.isRunning()) {
            try {
                this.eventHandler();
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (Exception e) {
                logger.error("Event service thread error", (Throwable)e);
            }
        }
    }

    private void eventHandler() {
        for (WorkflowExecuteThread workflowExecuteThread : this.processInstanceExecCacheManager.getAll()) {
            this.workflowExecuteThreadPool.executeEvent(workflowExecuteThread);
        }
    }
}

