/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.SlotCheckState;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.registry.ServerNodeManager;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterSchedulerService
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(MasterSchedulerService.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ProcessAlertManager processAlertManager;
    private NettyRemotingClient nettyRemotingClient;
    @Autowired
    NettyExecutorManager nettyExecutorManager;
    private ThreadPoolExecutor masterPrepareExecService;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;

    public void init() {
        this.masterPrepareExecService = (ThreadPoolExecutor)ThreadUtils.newDaemonFixedThreadExecutor((String)"Master-Pre-Exec-Thread", (int)this.masterConfig.getPreExecThreads());
        NettyClientConfig clientConfig = new NettyClientConfig();
        this.nettyRemotingClient = new NettyRemotingClient(clientConfig);
    }

    @Override
    public synchronized void start() {
        super.setName("MasterSchedulerService");
        super.start();
        this.stateWheelExecuteThread.start();
    }

    public void close() {
        this.nettyRemotingClient.close();
        logger.info("master schedule service stopped...");
    }

    @Override
    public void run() {
        logger.info("master scheduler started");
        while (Stopper.isRunning()) {
            try {
                boolean runCheckFlag = OSUtils.checkResource((double)this.masterConfig.getMaxCpuLoadAvg(), (double)this.masterConfig.getReservedMemory());
                if (!runCheckFlag) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.scheduleProcess();
            }
            catch (Exception e) {
                logger.error("master scheduler thread error", (Throwable)e);
            }
        }
    }

    private void scheduleProcess() throws Exception {
        List<Command> commands = this.findCommands();
        if (CollectionUtils.isEmpty(commands)) {
            Thread.sleep(1000L);
            return;
        }
        List<ProcessInstance> processInstances = this.command2ProcessInstance(commands);
        if (CollectionUtils.isEmpty(processInstances)) {
            return;
        }
        for (ProcessInstance processInstance : processInstances) {
            if (processInstance == null) continue;
            WorkflowExecuteThread workflowExecuteThread = new WorkflowExecuteThread(processInstance, this.processService, this.nettyExecutorManager, this.processAlertManager, this.masterConfig, this.stateWheelExecuteThread);
            this.processInstanceExecCacheManager.cache(processInstance.getId(), workflowExecuteThread);
            if (processInstance.getTimeout() > 0) {
                this.stateWheelExecuteThread.addProcess4TimeoutCheck(processInstance);
            }
            this.workflowExecuteThreadPool.startWorkflow(workflowExecuteThread);
        }
    }

    private List<ProcessInstance> command2ProcessInstance(List<Command> commands) {
        List<ProcessInstance> processInstances = Collections.synchronizedList(new ArrayList(commands.size()));
        CountDownLatch latch = new CountDownLatch(commands.size());
        for (Command command : commands) {
            this.masterPrepareExecService.execute(() -> {
                try {
                    SlotCheckState slotCheckState = this.slotCheck(command);
                    if (slotCheckState.equals((Object)SlotCheckState.CHANGE) || slotCheckState.equals((Object)SlotCheckState.INJECT)) {
                        logger.info("handle command {} skip, slot check state: {}", (Object)command.getId(), (Object)slotCheckState);
                        return;
                    }
                    ProcessInstance processInstance = this.processService.handleCommand(logger, this.getLocalAddress(), command);
                    if (processInstance != null) {
                        processInstances.add(processInstance);
                        logger.info("handle command {} end, create process instance {}", (Object)command.getId(), (Object)processInstance.getId());
                    }
                }
                catch (Exception e) {
                    logger.error("handle command error ", (Throwable)e);
                    this.processService.moveToErrorCommand(command, e.toString());
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("countDownLatch await error ", (Throwable)e);
        }
        return processInstances;
    }

    private List<Command> findCommands() {
        int pageNumber = 0;
        int pageSize = this.masterConfig.getFetchCommandNum();
        List<Object> result = new ArrayList<Command>();
        if (Stopper.isRunning()) {
            int thisMasterSlot = ServerNodeManager.getSlot();
            int masterCount = ServerNodeManager.getMasterSize();
            if (masterCount > 0) {
                result = this.processService.findCommandPageBySlot(pageSize, pageNumber, masterCount, thisMasterSlot);
            }
        }
        return result;
    }

    private SlotCheckState slotCheck(Command command) {
        int slot = ServerNodeManager.getSlot();
        int masterSize = ServerNodeManager.getMasterSize();
        SlotCheckState state = masterSize <= 0 ? SlotCheckState.CHANGE : (command.getId() % masterSize == slot ? SlotCheckState.PASS : SlotCheckState.INJECT);
        return state;
    }

    private String getLocalAddress() {
        return NetUtils.getAddr((int)this.masterConfig.getListenPort());
    }
}

