/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.util.Objects;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;

public class TaskInstanceKey {
    private int processInstanceId;
    private long taskCode;
    private int taskVersion;

    public TaskInstanceKey(int processInstanceId, long taskCode, int taskVersion) {
        this.processInstanceId = processInstanceId;
        this.taskCode = taskCode;
        this.taskVersion = taskVersion;
    }

    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    public long getTaskCode() {
        return this.taskCode;
    }

    public int getTaskVersion() {
        return this.taskVersion;
    }

    public static TaskInstanceKey getTaskInstanceKey(ProcessInstance processInstance, TaskInstance taskInstance) {
        if (processInstance == null || taskInstance == null) {
            return null;
        }
        return new TaskInstanceKey(processInstance.getId(), taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
    }

    public String toString() {
        return "TaskKey{processInstanceId=" + this.processInstanceId + ", taskCode=" + this.taskCode + ", taskVersion=" + this.taskVersion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstanceKey taskInstanceKey = (TaskInstanceKey)o;
        return this.processInstanceId == taskInstanceKey.processInstanceId && this.taskCode == taskInstanceKey.taskCode && this.taskVersion == taskInstanceKey.taskVersion;
    }

    public int hashCode() {
        return Objects.hash(this.processInstanceId, this.taskCode, this.taskVersion);
    }
}

