/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectionStateListener;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryDataListener;
import org.apache.dolphinscheduler.server.master.service.FailoverService;
import org.apache.dolphinscheduler.server.registry.HeartBeatTask;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterRegistryClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MasterRegistryClient.class);
    @Autowired
    private FailoverService failoverService;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MasterConfig masterConfig;
    private ScheduledExecutorService heartBeatExecutor;
    private long startupTime;
    private String masterAddress;

    public void init() {
        this.masterAddress = NetUtils.getAddr((int)this.masterConfig.getListenPort());
        this.startupTime = System.currentTimeMillis();
        this.heartBeatExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HeartBeatExecutor"));
    }

    public void start() {
        try {
            this.registry();
            this.registryClient.addConnectionStateListener((ConnectionListener)new MasterConnectionStateListener(this.getCurrentNodePath(), this.registryClient));
            this.registryClient.subscribe("/nodes", (SubscribeListener)new MasterRegistryDataListener());
        }
        catch (Exception e) {
            throw new RegistryException("Master registry client start up error", (Throwable)e);
        }
    }

    public void setRegistryStoppable(IStoppable stoppable) {
        this.registryClient.setStoppable(stoppable);
    }

    @Override
    public void close() {
        this.deregister();
    }

    public void removeMasterNodePath(String path, NodeType nodeType, boolean failover) {
        logger.info("{} node deleted : {}", (Object)nodeType, (Object)path);
        if (StringUtils.isEmpty((CharSequence)path)) {
            logger.error("server down error: empty path: {}, nodeType:{}", (Object)path, (Object)nodeType);
            return;
        }
        String serverHost = this.registryClient.getHostByEventDataPath(path);
        if (StringUtils.isEmpty((CharSequence)serverHost)) {
            logger.error("server down error: unknown path: {}, nodeType:{}", (Object)path, (Object)nodeType);
            return;
        }
        try {
            if (!this.registryClient.exists(path)) {
                logger.info("path: {} not exists", (Object)path);
                this.registryClient.handleDeadServer(Collections.singleton(path), nodeType, "add");
            }
            if (failover) {
                this.failoverService.failoverServerWhenDown(serverHost, nodeType);
            }
        }
        catch (Exception e) {
            logger.error("{} server failover failed, host:{}", new Object[]{nodeType, serverHost, e});
        }
    }

    public void removeWorkerNodePath(String path, NodeType nodeType, boolean failover) {
        logger.info("{} node deleted : {}", (Object)nodeType, (Object)path);
        try {
            String serverHost = null;
            if (!StringUtils.isEmpty((CharSequence)path)) {
                serverHost = this.registryClient.getHostByEventDataPath(path);
                if (StringUtils.isEmpty((CharSequence)serverHost)) {
                    logger.error("server down error: unknown path: {}", (Object)path);
                    return;
                }
                if (!this.registryClient.exists(path)) {
                    logger.info("path: {} not exists", (Object)path);
                    this.registryClient.handleDeadServer(Collections.singleton(path), nodeType, "add");
                }
            }
            if (failover) {
                this.failoverService.failoverServerWhenDown(serverHost, nodeType);
            }
        }
        catch (Exception e) {
            logger.error("{} server failover failed", (Object)nodeType, (Object)e);
        }
    }

    void registry() {
        logger.info("Master node : {} registering to registry center", (Object)this.masterAddress);
        String localNodePath = this.getCurrentNodePath();
        Duration masterHeartbeatInterval = this.masterConfig.getHeartbeatInterval();
        HeartBeatTask heartBeatTask = new HeartBeatTask(this.startupTime, this.masterConfig.getMaxCpuLoadAvg(), this.masterConfig.getReservedMemory(), (Set)Sets.newHashSet((Object[])new String[]{localNodePath}), "master", this.registryClient, this.masterConfig.getHeartbeatErrorThreshold());
        this.registryClient.remove(localNodePath);
        this.registryClient.persistEphemeral(localNodePath, heartBeatTask.getHeartBeatInfo());
        while (!this.registryClient.checkNodeExists(NetUtils.getHost(), NodeType.MASTER)) {
            logger.warn("The current master server node:{} cannot find in registry", (Object)NetUtils.getHost());
            ThreadUtils.sleep((long)1000L);
        }
        ThreadUtils.sleep((long)1000L);
        this.registryClient.handleDeadServer(Collections.singleton(localNodePath), NodeType.MASTER, "delete");
        this.heartBeatExecutor.scheduleAtFixedRate((Runnable)heartBeatTask, 0L, masterHeartbeatInterval.getSeconds(), TimeUnit.SECONDS);
        logger.info("Master node : {} registered to registry center successfully with heartBeatInterval : {}s", (Object)this.masterAddress, (Object)masterHeartbeatInterval);
    }

    public void deregister() {
        try {
            String address = this.getLocalAddress();
            String localNodePath = this.getCurrentNodePath();
            this.registryClient.remove(localNodePath);
            logger.info("Master node : {} unRegistry to register center.", (Object)address);
            this.heartBeatExecutor.shutdown();
            logger.info("MasterServer heartbeat executor shutdown");
            this.registryClient.close();
        }
        catch (Exception e) {
            logger.error("MasterServer remove registry path exception ", (Throwable)e);
        }
    }

    private String getCurrentNodePath() {
        String address = this.getLocalAddress();
        return "/nodes/master/" + address;
    }

    private String getLocalAddress() {
        return NetUtils.getAddr((int)this.masterConfig.getListenPort());
    }
}

