/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.BlockingOpportunity;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.BlockingParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.utils.LogUtils;

@AutoService(value={ITaskProcessor.class})
public class BlockingTaskProcessor
extends BaseTaskProcessor {
    private DependentParameters dependentParameters;
    private DependResult conditionResult = DependResult.WAITING;
    private BlockingParameters blockingParam;
    private Map<Long, ExecutionStatus> completeTaskList = new ConcurrentHashMap<Long, ExecutionStatus>();

    private void initTaskParameters() {
        this.taskInstance.setLogPath(LogUtils.getTaskLogPath((Date)this.taskInstance.getFirstSubmitTime(), (Long)this.processInstance.getProcessDefinitionCode(), (int)this.processInstance.getProcessDefinitionVersion(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId()));
        this.taskInstance.setHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        this.dependentParameters = this.taskInstance.getDependency();
        this.blockingParam = (BlockingParameters)JSONUtils.parseObject((String)this.taskInstance.getTaskParams(), BlockingParameters.class);
    }

    @Override
    protected boolean pauseTask() {
        this.taskInstance.setState(ExecutionStatus.PAUSE);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        this.logger.info("blocking task has been paused");
        return true;
    }

    @Override
    protected boolean killTask() {
        this.taskInstance.setState(ExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        this.logger.info("blocking task has been killed");
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        return true;
    }

    @Override
    protected boolean submitTask() {
        this.taskInstance = this.processService.submitTaskWithRetry(this.processInstance, this.taskInstance, this.maxRetryTimes, this.commitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.setTaskExecutionLogger();
        this.initTaskParameters();
        this.logger.info("blocking task start");
        return true;
    }

    @Override
    protected boolean runTask() {
        if (this.conditionResult.equals((Object)DependResult.WAITING)) {
            this.setConditionResult();
            this.endTask();
        } else {
            this.endTask();
        }
        return true;
    }

    @Override
    protected boolean dispatchTask() {
        return false;
    }

    @Override
    public String getType() {
        return "BLOCKING";
    }

    private DependResult getDependResultForItem(DependentItem item) {
        DependResult dependResult = DependResult.SUCCESS;
        if (!this.completeTaskList.containsKey(item.getDepTaskCode())) {
            this.logger.info("depend item: {} have not completed yet.", (Object)item.getDepTaskCode());
            dependResult = DependResult.FAILED;
            return dependResult;
        }
        ExecutionStatus executionStatus = this.completeTaskList.get(item.getDepTaskCode());
        if (executionStatus != item.getStatus()) {
            this.logger.info("depend item : {} expect status: {}, actual status: {}", new Object[]{item.getDepTaskCode(), item.getStatus(), executionStatus});
            dependResult = DependResult.FAILED;
        }
        this.logger.info("dependent item complete {} {},{}", new Object[]{":||", item.getDepTaskCode(), dependResult});
        return dependResult;
    }

    private void setConditionResult() {
        List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.taskInstance.getProcessInstanceId()));
        for (TaskInstance task : taskInstances) {
            this.completeTaskList.putIfAbsent(task.getTaskCode(), task.getState());
        }
        ArrayList<DependResult> tempResultList = new ArrayList<DependResult>();
        for (DependentTaskModel dependentTaskModel : this.dependentParameters.getDependTaskList()) {
            ArrayList<DependResult> itemDependResult = new ArrayList<DependResult>();
            for (DependentItem item : dependentTaskModel.getDependItemList()) {
                itemDependResult.add(this.getDependResultForItem(item));
            }
            DependResult tempResult = DependentUtils.getDependResultForRelation((DependentRelation)dependentTaskModel.getRelation(), itemDependResult);
            tempResultList.add(tempResult);
        }
        this.conditionResult = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), tempResultList);
        this.logger.info("the blocking task depend result : {}", (Object)this.conditionResult);
    }

    private void endTask() {
        ExecutionStatus status = ExecutionStatus.SUCCESS;
        DependResult expected = this.blockingParam.getBlockingOpportunity().equals(BlockingOpportunity.BLOCKING_ON_SUCCESS.getDesc()) ? DependResult.SUCCESS : DependResult.FAILED;
        boolean isBlocked = expected == this.conditionResult;
        this.logger.info("blocking opportunity: expected-->{}, actual-->{}", (Object)expected, (Object)this.conditionResult);
        this.processInstance.setBlocked(isBlocked);
        if (isBlocked) {
            this.processInstance.setState(ExecutionStatus.READY_BLOCK);
        }
        this.taskInstance.setState(status);
        this.taskInstance.setEndTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
        this.logger.info("blocking task execute complete, blocking:{}", (Object)isBlocked);
    }
}

