/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.function.Supplier;

public final class TaskMetrics {
    private static final Counter TASK_SUBMIT_COUNTER = Counter.builder((String)"ds.task.submit.count").description("Task submit total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_FINISH_COUNTER = Counter.builder((String)"ds.task.finish.count").description("Task finish total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_SUCCESS_COUNTER = Counter.builder((String)"ds.task.success.count").description("Task success total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_FAILURE_COUNTER = Counter.builder((String)"ds.task.failure.count").description("Task failure total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_TIMEOUT_COUNTER = Counter.builder((String)"ds.task.timeout.count").description("Task timeout total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_RETRY_COUNTER = Counter.builder((String)"ds.task.retry.count").description("Task retry total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_STOP_COUNTER = Counter.builder((String)"ds.task.stop.count").description("Task stop total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_FAILOVER_COUNTER = Counter.builder((String)"ds.task.failover.count").description("Task failover total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_DISPATCH_COUNTER = Counter.builder((String)"ds.task.dispatch.count").description("Task dispatch count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_DISPATCHER_FAILED = Counter.builder((String)"ds.task.dispatch.failure.count").description("Task dispatch failed count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter TASK_DISPATCH_ERROR = Counter.builder((String)"ds.task.dispatch.error.count").description("Task dispatch error").register((MeterRegistry)Metrics.globalRegistry);

    private TaskMetrics() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void incTaskSubmit() {
        TASK_SUBMIT_COUNTER.increment();
    }

    public static synchronized void registerTaskPrepared(Supplier<Number> consumer) {
        Gauge.builder((String)"ds.task.prepared", consumer).description("Task prepared count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void incTaskFinish() {
        TASK_FINISH_COUNTER.increment();
    }

    public static void incTaskSuccess() {
        TASK_SUCCESS_COUNTER.increment();
    }

    public static void incTaskFailure() {
        TASK_FAILURE_COUNTER.increment();
    }

    public static void incTaskTimeout() {
        TASK_TIMEOUT_COUNTER.increment();
    }

    public static void incTaskRetry() {
        TASK_RETRY_COUNTER.increment();
    }

    public static void incTaskStop() {
        TASK_STOP_COUNTER.increment();
    }

    public static void incTaskFailover() {
        TASK_FAILOVER_COUNTER.increment();
    }

    public static void incTaskDispatchFailed(int failedCount) {
        TASK_DISPATCHER_FAILED.increment((double)failedCount);
    }

    public static void incTaskDispatchError() {
        TASK_DISPATCH_ERROR.increment();
    }

    public static void incTaskDispatch() {
        TASK_DISPATCH_COUNTER.increment();
    }
}

