/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.server.builder.TaskExecutionContextBuilder;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.server.master.runner.task.TaskProcessorFactory;
import org.apache.dolphinscheduler.server.utils.ProcessUtils;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkerFailoverService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerFailoverService.class);
    private final RegistryClient registryClient;
    private final MasterConfig masterConfig;
    private final ProcessService processService;
    private final WorkflowExecuteThreadPool workflowExecuteThreadPool;
    private final ProcessInstanceExecCacheManager cacheManager;
    private final String localAddress;

    public WorkerFailoverService(@NonNull RegistryClient registryClient, @NonNull MasterConfig masterConfig, @NonNull ProcessService processService, @NonNull WorkflowExecuteThreadPool workflowExecuteThreadPool, @NonNull ProcessInstanceExecCacheManager cacheManager) {
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (masterConfig == null) {
            throw new NullPointerException("masterConfig is marked non-null but is null");
        }
        if (processService == null) {
            throw new NullPointerException("processService is marked non-null but is null");
        }
        if (workflowExecuteThreadPool == null) {
            throw new NullPointerException("workflowExecuteThreadPool is marked non-null but is null");
        }
        if (cacheManager == null) {
            throw new NullPointerException("cacheManager is marked non-null but is null");
        }
        this.registryClient = registryClient;
        this.masterConfig = masterConfig;
        this.processService = processService;
        this.workflowExecuteThreadPool = workflowExecuteThreadPool;
        this.cacheManager = cacheManager;
        this.localAddress = NetUtils.getAddr((int)masterConfig.getListenPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failoverWorker(@NonNull String workerHost) {
        if (workerHost == null) {
            throw new NullPointerException("workerHost is marked non-null but is null");
        }
        LOGGER.info("Worker[{}] failover starting", (Object)workerHost);
        StopWatch failoverTimeCost = StopWatch.createStarted();
        Optional<Date> needFailoverWorkerStartTime = this.getServerStartupTime(this.registryClient.getServerList(NodeType.WORKER), workerHost);
        List<TaskInstance> needFailoverTaskInstanceList = this.getNeedFailoverTaskInstance(workerHost);
        if (CollectionUtils.isEmpty(needFailoverTaskInstanceList)) {
            LOGGER.info("Worker[{}] failover finished there are no taskInstance need to failover", (Object)workerHost);
            return;
        }
        LOGGER.info("Worker[{}] failover there are {} taskInstance may need to failover, will do a deep check, taskInstanceIds: {}", new Object[]{workerHost, needFailoverTaskInstanceList.size(), needFailoverTaskInstanceList.stream().map(TaskInstance::getId).collect(Collectors.toList())});
        HashMap<Integer, ProcessInstance> processInstanceCacheMap = new HashMap<Integer, ProcessInstance>();
        for (TaskInstance taskInstance : needFailoverTaskInstanceList) {
            LoggerUtils.setWorkflowAndTaskInstanceIDMDC((int)taskInstance.getProcessInstanceId(), (int)taskInstance.getId());
            try {
                ProcessInstance processInstance = processInstanceCacheMap.computeIfAbsent(taskInstance.getProcessInstanceId(), k -> {
                    WorkflowExecuteRunnable workflowExecuteRunnable = this.cacheManager.getByProcessInstanceId(taskInstance.getProcessInstanceId());
                    if (workflowExecuteRunnable == null) {
                        return null;
                    }
                    return workflowExecuteRunnable.getProcessInstance();
                });
                if (!this.checkTaskInstanceNeedFailover(needFailoverWorkerStartTime, processInstance, taskInstance)) {
                    LOGGER.info("Worker[{}] the current taskInstance doesn't need to failover", (Object)workerHost);
                    continue;
                }
                LOGGER.info("Worker[{}] failover: begin to failover taskInstance, will set the status to NEED_FAULT_TOLERANCE", (Object)workerHost);
                this.failoverTaskInstance(processInstance, taskInstance);
                LOGGER.info("Worker[{}] failover: Finish failover taskInstance", (Object)workerHost);
            }
            catch (Exception ex) {
                LOGGER.info("Worker[{}] failover taskInstance occur exception", (Object)workerHost, (Object)ex);
            }
            finally {
                LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
            }
        }
        failoverTimeCost.stop();
        LOGGER.info("Worker[{}] failover finished, useTime:{}ms", (Object)workerHost, (Object)failoverTimeCost.getTime(TimeUnit.MILLISECONDS));
    }

    private void failoverTaskInstance(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        TaskMetrics.incTaskFailover();
        boolean isMasterTask = TaskProcessorFactory.isMasterTask(taskInstance.getTaskType());
        taskInstance.setProcessInstance(processInstance);
        if (!isMasterTask) {
            LOGGER.info("The failover taskInstance is not master task");
            TaskExecutionContext taskExecutionContext = TaskExecutionContextBuilder.get().buildTaskInstanceRelatedInfo(taskInstance).buildProcessInstanceRelatedInfo(processInstance).buildProcessDefinitionRelatedInfo(processInstance.getProcessDefinition()).create();
            if (this.masterConfig.isKillYarnJobWhenTaskFailover()) {
                LOGGER.info("TaskInstance failover begin kill the task related yarn job");
                ProcessUtils.killYarnJob((TaskExecutionContext)taskExecutionContext);
            }
        } else {
            LOGGER.info("The failover taskInstance is a master task");
        }
        taskInstance.setState(ExecutionStatus.NEED_FAULT_TOLERANCE);
        taskInstance.setFlag(Flag.NO);
        this.processService.saveTaskInstance(taskInstance);
        StateEvent stateEvent = new StateEvent();
        stateEvent.setTaskInstanceId(taskInstance.getId());
        stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
        stateEvent.setProcessInstanceId(processInstance.getId());
        stateEvent.setExecutionStatus(taskInstance.getState());
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    private boolean checkTaskInstanceNeedFailover(Optional<Date> needFailoverWorkerStartTime, @Nullable ProcessInstance processInstance, TaskInstance taskInstance) {
        if (processInstance == null) {
            LOGGER.error("Failover task instance error, cannot find the related processInstance form memory, this case shouldn't happened");
            return false;
        }
        if (taskInstance == null) {
            LOGGER.error("Master failover task instance error, taskInstance is null, this case shouldn't happened");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)processInstance.getHost(), (CharSequence)this.localAddress)) {
            LOGGER.error("Master failover task instance error, the taskInstance's processInstance's host: {} is not the current master: {}", (Object)processInstance.getHost(), (Object)this.localAddress);
            return false;
        }
        if (taskInstance.getState() != null && taskInstance.getState().typeIsFinished()) {
            LOGGER.info("The task is already finished, doesn't need to failover");
            return false;
        }
        if (!needFailoverWorkerStartTime.isPresent()) {
            return true;
        }
        if (taskInstance.getSubmitTime() != null && taskInstance.getSubmitTime().after(needFailoverWorkerStartTime.get())) {
            LOGGER.info("The taskInstance's submitTime: {} is after the need failover worker's start time: {}, the taskInstance is newly submit, it doesn't need to failover", (Object)taskInstance.getSubmitTime(), (Object)needFailoverWorkerStartTime.get());
            return false;
        }
        return true;
    }

    private List<TaskInstance> getNeedFailoverTaskInstance(@NonNull String failoverWorkerHost) {
        if (failoverWorkerHost == null) {
            throw new NullPointerException("failoverWorkerHost is marked non-null but is null");
        }
        return this.cacheManager.getAll().stream().flatMap(workflowExecuteRunnable -> workflowExecuteRunnable.getAllTaskInstances().stream()).filter(taskInstance -> failoverWorkerHost.equals(taskInstance.getHost()) && ExecutionStatus.isNeedFailoverWorkflowInstanceState((ExecutionStatus)taskInstance.getState())).collect(Collectors.toList());
    }

    private Optional<Date> getServerStartupTime(List<Server> servers, String host) {
        if (CollectionUtils.isEmpty(servers)) {
            return Optional.empty();
        }
        Date serverStartupTime = null;
        for (Server server : servers) {
            if (!host.equals(server.getHost() + ":" + server.getPort())) continue;
            serverStartupTime = server.getCreateTime();
            break;
        }
        return Optional.ofNullable(serverStartupTime);
    }
}

