/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventExecuteService
extends BaseDaemonThread {
    private static final Logger logger = LoggerFactory.getLogger(EventExecuteService.class);
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;

    protected EventExecuteService() {
        super("EventServiceStarted");
    }

    public synchronized void start() {
        logger.info("Master Event execute service starting");
        super.start();
        logger.info("Master Event execute service started");
    }

    public void run() {
        while (Stopper.isRunning()) {
            try {
                this.eventHandler();
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                logger.warn("Master event service interrupted, will exit this loop", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                logger.error("Master event execute service error", (Throwable)e);
            }
        }
    }

    private void eventHandler() {
        for (WorkflowExecuteRunnable workflowExecuteThread : this.processInstanceExecCacheManager.getAll()) {
            try {
                LoggerUtils.setWorkflowInstanceIdMDC((int)workflowExecuteThread.getProcessInstance().getId());
                this.workflowExecuteThreadPool.executeEvent(workflowExecuteThread);
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }
}

