/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.SwitchResultVo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SwitchParameters;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.utils.LogUtils;
import org.apache.dolphinscheduler.server.utils.SwitchTaskUtils;

@AutoService(value={ITaskProcessor.class})
public class SwitchTaskProcessor
extends BaseTaskProcessor {
    protected final String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";
    private DependResult conditionResult;

    @Override
    public boolean submitTask() {
        this.taskInstance = this.processService.submitTaskWithRetry(this.processInstance, this.taskInstance, this.maxRetryTimes, this.commitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.setTaskExecutionLogger();
        this.logger.info("switch task submit success");
        return true;
    }

    @Override
    public boolean runTask() {
        this.logger.info("switch task starting");
        this.taskInstance.setLogPath(LogUtils.getTaskLogPath((Date)this.taskInstance.getFirstSubmitTime(), (Long)this.processInstance.getProcessDefinitionCode(), (int)this.processInstance.getProcessDefinitionVersion(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId()));
        this.taskInstance.setHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
        if (!this.taskInstance().getState().typeIsFinished()) {
            this.setSwitchResult();
        }
        this.endTaskState();
        this.logger.info("switch task finished");
        return true;
    }

    @Override
    protected boolean dispatchTask() {
        return true;
    }

    @Override
    protected boolean pauseTask() {
        this.taskInstance.setState(ExecutionStatus.PAUSE);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean killTask() {
        this.taskInstance.setState(ExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        return true;
    }

    @Override
    public String getType() {
        return "SWITCH";
    }

    private boolean setSwitchResult() {
        List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.taskInstance.getProcessInstanceId()));
        HashMap<String, ExecutionStatus> completeTaskList = new HashMap<String, ExecutionStatus>();
        for (TaskInstance task : taskInstances) {
            completeTaskList.putIfAbsent(task.getName(), task.getState());
        }
        SwitchParameters switchParameters = this.taskInstance.getSwitchDependency();
        List switchResultVos = switchParameters.getDependTaskList();
        SwitchResultVo switchResultVo = new SwitchResultVo();
        switchResultVo.setNextNode((Object)switchParameters.getNextNode());
        switchResultVos.add(switchResultVo);
        int finalConditionLocation = switchResultVos.size() - 1;
        int i = 0;
        this.conditionResult = DependResult.SUCCESS;
        for (SwitchResultVo info : switchResultVos) {
            this.logger.info("the {} execution ", (Object)(i + 1));
            this.logger.info("original condition sentence\uff1a{}", (Object)info.getCondition());
            if (StringUtils.isEmpty((CharSequence)info.getCondition())) {
                finalConditionLocation = i;
                break;
            }
            String content = this.setTaskParams(info.getCondition().replaceAll("'", "\""), "['\"]*\\$\\{(.*?)\\}['\"]*");
            this.logger.info("format condition sentence::{}", (Object)content);
            Boolean result = null;
            try {
                result = SwitchTaskUtils.evaluate(content);
            }
            catch (Exception e) {
                this.logger.info("error sentence : {}", (Object)content);
                this.conditionResult = DependResult.FAILED;
                break;
            }
            this.logger.info("condition result : {}", (Object)result);
            if (result.booleanValue()) {
                finalConditionLocation = i;
                break;
            }
            ++i;
        }
        switchParameters.setDependTaskList(switchResultVos);
        switchParameters.setResultConditionLocation(finalConditionLocation);
        this.taskInstance.setSwitchDependency(switchParameters);
        if (!this.isValidSwitchResult((SwitchResultVo)switchResultVos.get(finalConditionLocation))) {
            this.conditionResult = DependResult.FAILED;
            this.logger.error("the switch task depend result is invalid, result:{}, switch branch:{}", (Object)this.conditionResult, (Object)finalConditionLocation);
            return true;
        }
        this.logger.info("the switch task depend result:{}, switch branch:{}", (Object)this.conditionResult, (Object)finalConditionLocation);
        return true;
    }

    private void endTaskState() {
        ExecutionStatus status = this.conditionResult == DependResult.SUCCESS ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE;
        this.taskInstance.setEndTime(new Date());
        this.taskInstance.setState(status);
        this.processService.updateTaskInstance(this.taskInstance);
    }

    public String setTaskParams(String content, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        Map<String, Property> globalParams = JSONUtils.toList((String)this.processInstance.getGlobalParams(), Property.class).stream().collect(Collectors.toMap(Property::getProp, Property2 -> Property2));
        Map<String, Property> varParams = JSONUtils.toList((String)this.taskInstance.getVarPool(), Property.class).stream().collect(Collectors.toMap(Property::getProp, Property2 -> Property2));
        if (varParams.size() > 0) {
            varParams.putAll(globalParams);
            globalParams = varParams;
        }
        while (m.find()) {
            String paramName = m.group(1);
            Property property = globalParams.get(paramName);
            if (property == null) {
                return "";
            }
            String value = property.getValue();
            if (!NumberUtils.isNumber((String)value)) {
                value = "\"" + value + "\"";
            }
            this.logger.info("paramName:{}\uff0cparamValue:{}", (Object)paramName, (Object)value);
            content = content.replace("${" + paramName + "}", value);
        }
        return content;
    }

    private boolean isValidSwitchResult(SwitchResultVo switchResult) {
        if (CollectionUtils.isEmpty((Collection)switchResult.getNextNode())) {
            return false;
        }
        for (String nextNode : switchResult.getNextNode()) {
            if (!StringUtils.isEmpty((CharSequence)nextNode)) continue;
            return false;
        }
        return true;
    }
}

