/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.config;

import java.time.Duration;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostSelector;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="master")
public class MasterConfig
implements Validator {
    private int listenPort = 5678;
    private int fetchCommandNum = 10;
    private int preExecThreads = 10;
    private int execThreads = 10;
    private int dispatchTaskNumber = 3;
    private HostSelector hostSelector = HostSelector.LOWER_WEIGHT;
    private Duration heartbeatInterval = Duration.ofSeconds(10L);
    private int heartbeatErrorThreshold = 5;
    private int taskCommitRetryTimes = 5;
    private Duration taskCommitInterval = Duration.ofSeconds(1L);
    private Duration stateWheelInterval = Duration.ofMillis(5L);
    private double maxCpuLoadAvg = -1.0;
    private double reservedMemory = 0.3;
    private Duration failoverInterval = Duration.ofMinutes(10L);
    private boolean killYarnJobWhenTaskFailover = true;
    private String masterAddress;

    public boolean supports(Class<?> clazz) {
        return MasterConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        MasterConfig masterConfig = (MasterConfig)target;
        if (masterConfig.getListenPort() <= 0) {
            errors.rejectValue("listen-port", null, "is invalidated");
        }
        if (masterConfig.getFetchCommandNum() <= 0) {
            errors.rejectValue("fetch-command-num", null, "should be a positive value");
        }
        if (masterConfig.getPreExecThreads() <= 0) {
            errors.rejectValue("per-exec-threads", null, "should be a positive value");
        }
        if (masterConfig.getExecThreads() <= 0) {
            errors.rejectValue("exec-threads", null, "should be a positive value");
        }
        if (masterConfig.getDispatchTaskNumber() <= 0) {
            errors.rejectValue("dispatch-task-number", null, "should be a positive value");
        }
        if (masterConfig.getHeartbeatInterval().toMillis() < 0L) {
            errors.rejectValue("heartbeat-interval", null, "should be a valid duration");
        }
        if (masterConfig.getTaskCommitRetryTimes() <= 0) {
            errors.rejectValue("task-commit-retry-times", null, "should be a positive value");
        }
        if (masterConfig.getTaskCommitInterval().toMillis() <= 0L) {
            errors.rejectValue("task-commit-interval", null, "should be a valid duration");
        }
        if (masterConfig.getStateWheelInterval().toMillis() <= 0L) {
            errors.rejectValue("state-wheel-interval", null, "should be a valid duration");
        }
        if (masterConfig.getFailoverInterval().toMillis() <= 0L) {
            errors.rejectValue("failover-interval", null, "should be a valid duration");
        }
        if (masterConfig.getMaxCpuLoadAvg() <= 0.0) {
            masterConfig.setMaxCpuLoadAvg(Runtime.getRuntime().availableProcessors() * 2);
        }
        if (masterConfig.getHeartbeatErrorThreshold() <= 0) {
            errors.rejectValue("heartbeat-error-threshold", null, "should be a positive value");
        }
        masterConfig.setMasterAddress(NetUtils.getAddr((int)masterConfig.getListenPort()));
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public int getFetchCommandNum() {
        return this.fetchCommandNum;
    }

    public int getPreExecThreads() {
        return this.preExecThreads;
    }

    public int getExecThreads() {
        return this.execThreads;
    }

    public int getDispatchTaskNumber() {
        return this.dispatchTaskNumber;
    }

    public HostSelector getHostSelector() {
        return this.hostSelector;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public int getHeartbeatErrorThreshold() {
        return this.heartbeatErrorThreshold;
    }

    public int getTaskCommitRetryTimes() {
        return this.taskCommitRetryTimes;
    }

    public Duration getTaskCommitInterval() {
        return this.taskCommitInterval;
    }

    public Duration getStateWheelInterval() {
        return this.stateWheelInterval;
    }

    public double getMaxCpuLoadAvg() {
        return this.maxCpuLoadAvg;
    }

    public double getReservedMemory() {
        return this.reservedMemory;
    }

    public Duration getFailoverInterval() {
        return this.failoverInterval;
    }

    public boolean isKillYarnJobWhenTaskFailover() {
        return this.killYarnJobWhenTaskFailover;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public void setFetchCommandNum(int fetchCommandNum) {
        this.fetchCommandNum = fetchCommandNum;
    }

    public void setPreExecThreads(int preExecThreads) {
        this.preExecThreads = preExecThreads;
    }

    public void setExecThreads(int execThreads) {
        this.execThreads = execThreads;
    }

    public void setDispatchTaskNumber(int dispatchTaskNumber) {
        this.dispatchTaskNumber = dispatchTaskNumber;
    }

    public void setHostSelector(HostSelector hostSelector) {
        this.hostSelector = hostSelector;
    }

    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public void setHeartbeatErrorThreshold(int heartbeatErrorThreshold) {
        this.heartbeatErrorThreshold = heartbeatErrorThreshold;
    }

    public void setTaskCommitRetryTimes(int taskCommitRetryTimes) {
        this.taskCommitRetryTimes = taskCommitRetryTimes;
    }

    public void setTaskCommitInterval(Duration taskCommitInterval) {
        this.taskCommitInterval = taskCommitInterval;
    }

    public void setStateWheelInterval(Duration stateWheelInterval) {
        this.stateWheelInterval = stateWheelInterval;
    }

    public void setMaxCpuLoadAvg(double maxCpuLoadAvg) {
        this.maxCpuLoadAvg = maxCpuLoadAvg;
    }

    public void setReservedMemory(double reservedMemory) {
        this.reservedMemory = reservedMemory;
    }

    public void setFailoverInterval(Duration failoverInterval) {
        this.failoverInterval = failoverInterval;
    }

    public void setKillYarnJobWhenTaskFailover(boolean killYarnJobWhenTaskFailover) {
        this.killYarnJobWhenTaskFailover = killYarnJobWhenTaskFailover;
    }

    public void setMasterAddress(String masterAddress) {
        this.masterAddress = masterAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterConfig)) {
            return false;
        }
        MasterConfig other = (MasterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListenPort() != other.getListenPort()) {
            return false;
        }
        if (this.getFetchCommandNum() != other.getFetchCommandNum()) {
            return false;
        }
        if (this.getPreExecThreads() != other.getPreExecThreads()) {
            return false;
        }
        if (this.getExecThreads() != other.getExecThreads()) {
            return false;
        }
        if (this.getDispatchTaskNumber() != other.getDispatchTaskNumber()) {
            return false;
        }
        if (this.getHeartbeatErrorThreshold() != other.getHeartbeatErrorThreshold()) {
            return false;
        }
        if (this.getTaskCommitRetryTimes() != other.getTaskCommitRetryTimes()) {
            return false;
        }
        if (Double.compare(this.getMaxCpuLoadAvg(), other.getMaxCpuLoadAvg()) != 0) {
            return false;
        }
        if (Double.compare(this.getReservedMemory(), other.getReservedMemory()) != 0) {
            return false;
        }
        if (this.isKillYarnJobWhenTaskFailover() != other.isKillYarnJobWhenTaskFailover()) {
            return false;
        }
        HostSelector this$hostSelector = this.getHostSelector();
        HostSelector other$hostSelector = other.getHostSelector();
        if (this$hostSelector == null ? other$hostSelector != null : !((Object)((Object)this$hostSelector)).equals((Object)other$hostSelector)) {
            return false;
        }
        Duration this$heartbeatInterval = this.getHeartbeatInterval();
        Duration other$heartbeatInterval = other.getHeartbeatInterval();
        if (this$heartbeatInterval == null ? other$heartbeatInterval != null : !((Object)this$heartbeatInterval).equals(other$heartbeatInterval)) {
            return false;
        }
        Duration this$taskCommitInterval = this.getTaskCommitInterval();
        Duration other$taskCommitInterval = other.getTaskCommitInterval();
        if (this$taskCommitInterval == null ? other$taskCommitInterval != null : !((Object)this$taskCommitInterval).equals(other$taskCommitInterval)) {
            return false;
        }
        Duration this$stateWheelInterval = this.getStateWheelInterval();
        Duration other$stateWheelInterval = other.getStateWheelInterval();
        if (this$stateWheelInterval == null ? other$stateWheelInterval != null : !((Object)this$stateWheelInterval).equals(other$stateWheelInterval)) {
            return false;
        }
        Duration this$failoverInterval = this.getFailoverInterval();
        Duration other$failoverInterval = other.getFailoverInterval();
        if (this$failoverInterval == null ? other$failoverInterval != null : !((Object)this$failoverInterval).equals(other$failoverInterval)) {
            return false;
        }
        String this$masterAddress = this.getMasterAddress();
        String other$masterAddress = other.getMasterAddress();
        return !(this$masterAddress == null ? other$masterAddress != null : !this$masterAddress.equals(other$masterAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MasterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListenPort();
        result = result * 59 + this.getFetchCommandNum();
        result = result * 59 + this.getPreExecThreads();
        result = result * 59 + this.getExecThreads();
        result = result * 59 + this.getDispatchTaskNumber();
        result = result * 59 + this.getHeartbeatErrorThreshold();
        result = result * 59 + this.getTaskCommitRetryTimes();
        long $maxCpuLoadAvg = Double.doubleToLongBits(this.getMaxCpuLoadAvg());
        result = result * 59 + (int)($maxCpuLoadAvg >>> 32 ^ $maxCpuLoadAvg);
        long $reservedMemory = Double.doubleToLongBits(this.getReservedMemory());
        result = result * 59 + (int)($reservedMemory >>> 32 ^ $reservedMemory);
        result = result * 59 + (this.isKillYarnJobWhenTaskFailover() ? 79 : 97);
        HostSelector $hostSelector = this.getHostSelector();
        result = result * 59 + ($hostSelector == null ? 43 : ((Object)((Object)$hostSelector)).hashCode());
        Duration $heartbeatInterval = this.getHeartbeatInterval();
        result = result * 59 + ($heartbeatInterval == null ? 43 : ((Object)$heartbeatInterval).hashCode());
        Duration $taskCommitInterval = this.getTaskCommitInterval();
        result = result * 59 + ($taskCommitInterval == null ? 43 : ((Object)$taskCommitInterval).hashCode());
        Duration $stateWheelInterval = this.getStateWheelInterval();
        result = result * 59 + ($stateWheelInterval == null ? 43 : ((Object)$stateWheelInterval).hashCode());
        Duration $failoverInterval = this.getFailoverInterval();
        result = result * 59 + ($failoverInterval == null ? 43 : ((Object)$failoverInterval).hashCode());
        String $masterAddress = this.getMasterAddress();
        result = result * 59 + ($masterAddress == null ? 43 : $masterAddress.hashCode());
        return result;
    }

    public String toString() {
        return "MasterConfig(listenPort=" + this.getListenPort() + ", fetchCommandNum=" + this.getFetchCommandNum() + ", preExecThreads=" + this.getPreExecThreads() + ", execThreads=" + this.getExecThreads() + ", dispatchTaskNumber=" + this.getDispatchTaskNumber() + ", hostSelector=" + (Object)((Object)this.getHostSelector()) + ", heartbeatInterval=" + this.getHeartbeatInterval() + ", heartbeatErrorThreshold=" + this.getHeartbeatErrorThreshold() + ", taskCommitRetryTimes=" + this.getTaskCommitRetryTimes() + ", taskCommitInterval=" + this.getTaskCommitInterval() + ", stateWheelInterval=" + this.getStateWheelInterval() + ", maxCpuLoadAvg=" + this.getMaxCpuLoadAvg() + ", reservedMemory=" + this.getReservedMemory() + ", failoverInterval=" + this.getFailoverInterval() + ", killYarnJobWhenTaskFailover=" + this.isKillYarnJobWhenTaskFailover() + ", masterAddress=" + this.getMasterAddress() + ")";
    }
}

