/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master;

import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.server.master.rpc.MasterRPCServer;
import org.apache.dolphinscheduler.server.master.runner.EventExecuteService;
import org.apache.dolphinscheduler.server.master.runner.FailoverExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.MasterSchedulerBootstrap;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@ComponentScan(value={"org.apache.dolphinscheduler"})
@EnableTransactionManagement
@EnableCaching
public class MasterServer
implements IStoppable {
    private static final Logger logger = LoggerFactory.getLogger(MasterServer.class);
    @Autowired
    private SpringApplicationContext springApplicationContext;
    @Autowired
    private MasterRegistryClient masterRegistryClient;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private MasterSchedulerBootstrap masterSchedulerBootstrap;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private EventExecuteService eventExecuteService;
    @Autowired
    private FailoverExecuteThread failoverExecuteThread;
    @Autowired
    private MasterRPCServer masterRPCServer;

    public static void main(String[] args) {
        Thread.currentThread().setName("Master-Server");
        SpringApplication.run(MasterServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void run() throws SchedulerException {
        this.masterRPCServer.start();
        this.taskPluginManager.installPlugin();
        this.masterRegistryClient.init();
        this.masterRegistryClient.start();
        this.masterRegistryClient.setRegistryStoppable(this);
        this.masterSchedulerBootstrap.init();
        this.masterSchedulerBootstrap.start();
        this.eventExecuteService.start();
        this.failoverExecuteThread.start();
        this.scheduler.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Stopper.isRunning()) {
                this.close("MasterServer shutdownHook");
            }
        }));
    }

    public void close(String cause) {
        if (!Stopper.stop()) {
            logger.warn("MasterServer is already stopped, current cause: {}", (Object)cause);
            return;
        }
        ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
        try (MasterSchedulerBootstrap closedSchedulerBootstrap = this.masterSchedulerBootstrap;
             MasterRPCServer closedRpcServer = this.masterRPCServer;
             MasterRegistryClient closedMasterRegistryClient = this.masterRegistryClient;
             SpringApplicationContext closedSpringContext = this.springApplicationContext;){
            logger.info("Master server is stopping, current cause : {}", (Object)cause);
        }
        catch (Exception e) {
            logger.error("MasterServer stop failed, current cause: {}", (Object)cause, (Object)e);
            return;
        }
        logger.info("MasterServer stopped, current cause: {}", (Object)cause);
    }

    public void stop(String cause) {
        this.close(cause);
    }
}

