/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.Optional;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleError;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class TaskStateEventHandler
implements StateEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(TaskStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException, StateEventHandleError {
        this.measureTaskState(stateEvent);
        workflowExecuteRunnable.checkTaskInstanceByStateEvent(stateEvent);
        Optional<TaskInstance> taskInstanceOptional = workflowExecuteRunnable.getTaskInstance(stateEvent.getTaskInstanceId());
        TaskInstance task = taskInstanceOptional.orElseThrow(() -> new StateEventHandleError("Cannot find task instance from taskMap by task instance id: " + stateEvent.getTaskInstanceId()));
        if (task.getState() == null) {
            throw new StateEventHandleError("Task state event handle error due to task state is null");
        }
        Map<Long, Integer> completeTaskMap = workflowExecuteRunnable.getCompleteTaskMap();
        if (task.getState().typeIsFinished()) {
            if (completeTaskMap.containsKey(task.getTaskCode()) && completeTaskMap.get(task.getTaskCode()).intValue() == task.getId()) {
                logger.warn("The task instance is already complete, stateEvent: {}", (Object)stateEvent);
                return true;
            }
            workflowExecuteRunnable.taskFinished(task);
            if (task.getTaskGroupId() > 0) {
                logger.info("The task instance need to release task Group: {}", (Object)task.getTaskGroupId());
                workflowExecuteRunnable.releaseTaskGroup(task);
            }
            return true;
        }
        Map<Long, ITaskProcessor> activeTaskProcessMap = workflowExecuteRunnable.getActiveTaskProcessMap();
        if (activeTaskProcessMap.containsKey(task.getTaskCode())) {
            ITaskProcessor iTaskProcessor = activeTaskProcessMap.get(task.getTaskCode());
            iTaskProcessor.action(TaskAction.RUN);
            if (iTaskProcessor.taskInstance().getState().typeIsFinished()) {
                if (iTaskProcessor.taskInstance().getState() != task.getState()) {
                    task.setState(iTaskProcessor.taskInstance().getState());
                }
                workflowExecuteRunnable.taskFinished(task);
            }
            return true;
        }
        throw new StateEventHandleError("Task state event handle error, due to the task is not in activeTaskProcessorMaps");
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.TASK_STATE_CHANGE;
    }

    private void measureTaskState(StateEvent taskStateEvent) {
        if (taskStateEvent == null || taskStateEvent.getExecutionStatus() == null) {
            logger.warn("The task event is broken..., taskEvent: {}", (Object)taskStateEvent);
            return;
        }
        if (taskStateEvent.getExecutionStatus().typeIsFinished()) {
            TaskMetrics.incTaskFinish();
        }
        switch (taskStateEvent.getExecutionStatus()) {
            case STOP: {
                TaskMetrics.incTaskStop();
                break;
            }
            case SUCCESS: {
                TaskMetrics.incTaskSuccess();
                break;
            }
            case FAILURE: {
                TaskMetrics.incTaskFailure();
                break;
            }
        }
    }
}

