/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import com.google.common.base.Preconditions;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.server.master.registry.MasterHeartBeatTask;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterConnectionStateListener
implements ConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(MasterConnectionStateListener.class);
    private final String masterNodePath;
    private final RegistryClient registryClient;
    private final MasterHeartBeatTask masterHeartBeatTask;

    public MasterConnectionStateListener(String masterNodePath, RegistryClient registryClient, MasterHeartBeatTask masterHeartBeatTask) {
        this.masterNodePath = (String)Preconditions.checkNotNull((Object)masterNodePath);
        this.registryClient = (RegistryClient)Preconditions.checkNotNull((Object)registryClient);
        this.masterHeartBeatTask = (MasterHeartBeatTask)Preconditions.checkNotNull((Object)masterHeartBeatTask);
    }

    public void onUpdate(ConnectionState state) {
        switch (state) {
            case CONNECTED: {
                logger.debug("registry connection state is {}", (Object)state);
                break;
            }
            case SUSPENDED: {
                logger.warn("registry connection state is {}, ready to retry connection", (Object)state);
                break;
            }
            case RECONNECTED: {
                logger.debug("registry connection state is {}, clean the node info", (Object)state);
                this.registryClient.remove(this.masterNodePath);
                this.registryClient.persistEphemeral(this.masterNodePath, this.masterHeartBeatTask.getHeartBeatInfo());
                break;
            }
            case DISCONNECTED: {
                logger.warn("registry connection state is {}, ready to stop myself", (Object)state);
                this.registryClient.getStoppable().stop("registry connection state is DISCONNECTED, stop myself");
                break;
            }
        }
    }
}

