/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dolphinscheduler.common.utils.HeartBeat;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterHeartBeatTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(MasterHeartBeatTask.class);
    private final Set<String> heartBeatPaths;
    private final RegistryClient registryClient;
    private final HeartBeat heartBeat;
    private final AtomicInteger heartBeatErrorTimes = new AtomicInteger();

    public MasterHeartBeatTask(long startupTime, double maxCpuloadAvg, double reservedMemory, Set<String> heartBeatPaths, RegistryClient registryClient) {
        this.heartBeatPaths = heartBeatPaths;
        this.registryClient = registryClient;
        this.heartBeat = new HeartBeat(startupTime, maxCpuloadAvg, reservedMemory);
    }

    public String getHeartBeatInfo() {
        return this.heartBeat.encodeHeartBeat();
    }

    @Override
    public void run() {
        try {
            for (String heartBeatPath : this.heartBeatPaths) {
                if (!this.registryClient.checkIsDeadServer(heartBeatPath, "master")) continue;
                this.registryClient.getStoppable().stop("i was judged to death, release resources and stop myself");
                return;
            }
            for (String heartBeatPath : this.heartBeatPaths) {
                this.registryClient.persistEphemeral(heartBeatPath, this.heartBeat.encodeHeartBeat());
            }
            this.heartBeatErrorTimes.set(0);
        }
        catch (Throwable ex) {
            this.logger.error("HeartBeat task execute failed, errorTimes: {}", (Object)this.heartBeatErrorTimes.get(), (Object)ex);
        }
    }
}

