/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.config;

import java.time.Duration;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.ConnectStrategyProperties;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="master")
public class MasterConfig
implements Validator {
    private Logger logger = LoggerFactory.getLogger(MasterConfig.class);
    private int listenPort = 5678;
    private int fetchCommandNum = 10;
    private int preExecThreads = 10;
    private int execThreads = 10;
    private int dispatchTaskNumber = 3;
    private HostSelector hostSelector = HostSelector.LOWER_WEIGHT;
    private Duration heartbeatInterval = Duration.ofSeconds(10L);
    private int taskCommitRetryTimes = 5;
    private Duration taskCommitInterval = Duration.ofSeconds(1L);
    private Duration stateWheelInterval = Duration.ofMillis(5L);
    private double maxCpuLoadAvg = -1.0;
    private double reservedMemory = 0.3;
    private Duration failoverInterval = Duration.ofMinutes(10L);
    private boolean killYarnJobWhenTaskFailover = true;
    private ConnectStrategyProperties registryDisconnectStrategy = new ConnectStrategyProperties();
    private String masterAddress;
    private String masterRegistryPath;

    public boolean supports(Class<?> clazz) {
        return MasterConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        MasterConfig masterConfig = (MasterConfig)target;
        if (masterConfig.getListenPort() <= 0) {
            errors.rejectValue("listen-port", null, "is invalidated");
        }
        if (masterConfig.getFetchCommandNum() <= 0) {
            errors.rejectValue("fetch-command-num", null, "should be a positive value");
        }
        if (masterConfig.getPreExecThreads() <= 0) {
            errors.rejectValue("per-exec-threads", null, "should be a positive value");
        }
        if (masterConfig.getExecThreads() <= 0) {
            errors.rejectValue("exec-threads", null, "should be a positive value");
        }
        if (masterConfig.getDispatchTaskNumber() <= 0) {
            errors.rejectValue("dispatch-task-number", null, "should be a positive value");
        }
        if (masterConfig.getHeartbeatInterval().toMillis() < 0L) {
            errors.rejectValue("heartbeat-interval", null, "should be a valid duration");
        }
        if (masterConfig.getTaskCommitRetryTimes() <= 0) {
            errors.rejectValue("task-commit-retry-times", null, "should be a positive value");
        }
        if (masterConfig.getTaskCommitInterval().toMillis() <= 0L) {
            errors.rejectValue("task-commit-interval", null, "should be a valid duration");
        }
        if (masterConfig.getStateWheelInterval().toMillis() <= 0L) {
            errors.rejectValue("state-wheel-interval", null, "should be a valid duration");
        }
        if (masterConfig.getFailoverInterval().toMillis() <= 0L) {
            errors.rejectValue("failover-interval", null, "should be a valid duration");
        }
        if (masterConfig.getMaxCpuLoadAvg() <= 0.0) {
            masterConfig.setMaxCpuLoadAvg(Runtime.getRuntime().availableProcessors() * 2);
        }
        masterConfig.setMasterAddress(NetUtils.getAddr((int)masterConfig.getListenPort()));
        masterConfig.setMasterRegistryPath("/nodes/master/" + masterConfig.getMasterAddress());
        this.printConfig();
    }

    private void printConfig() {
        this.logger.info("Master config: listenPort -> {} ", (Object)this.listenPort);
        this.logger.info("Master config: fetchCommandNum -> {} ", (Object)this.fetchCommandNum);
        this.logger.info("Master config: preExecThreads -> {} ", (Object)this.preExecThreads);
        this.logger.info("Master config: execThreads -> {} ", (Object)this.execThreads);
        this.logger.info("Master config: dispatchTaskNumber -> {} ", (Object)this.dispatchTaskNumber);
        this.logger.info("Master config: hostSelector -> {} ", (Object)this.hostSelector);
        this.logger.info("Master config: heartbeatInterval -> {} ", (Object)this.heartbeatInterval);
        this.logger.info("Master config: taskCommitRetryTimes -> {} ", (Object)this.taskCommitRetryTimes);
        this.logger.info("Master config: taskCommitInterval -> {} ", (Object)this.taskCommitInterval);
        this.logger.info("Master config: stateWheelInterval -> {} ", (Object)this.stateWheelInterval);
        this.logger.info("Master config: maxCpuLoadAvg -> {} ", (Object)this.maxCpuLoadAvg);
        this.logger.info("Master config: reservedMemory -> {} ", (Object)this.reservedMemory);
        this.logger.info("Master config: failoverInterval -> {} ", (Object)this.failoverInterval);
        this.logger.info("Master config: killYarnJobWhenTaskFailover -> {} ", (Object)this.killYarnJobWhenTaskFailover);
        this.logger.info("Master config: registryDisconnectStrategy -> {} ", (Object)this.registryDisconnectStrategy);
        this.logger.info("Master config: masterAddress -> {} ", (Object)this.masterAddress);
        this.logger.info("Master config: masterRegistryPath -> {} ", (Object)this.masterRegistryPath);
    }

    @Generated
    public MasterConfig() {
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public int getListenPort() {
        return this.listenPort;
    }

    @Generated
    public int getFetchCommandNum() {
        return this.fetchCommandNum;
    }

    @Generated
    public int getPreExecThreads() {
        return this.preExecThreads;
    }

    @Generated
    public int getExecThreads() {
        return this.execThreads;
    }

    @Generated
    public int getDispatchTaskNumber() {
        return this.dispatchTaskNumber;
    }

    @Generated
    public HostSelector getHostSelector() {
        return this.hostSelector;
    }

    @Generated
    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Generated
    public int getTaskCommitRetryTimes() {
        return this.taskCommitRetryTimes;
    }

    @Generated
    public Duration getTaskCommitInterval() {
        return this.taskCommitInterval;
    }

    @Generated
    public Duration getStateWheelInterval() {
        return this.stateWheelInterval;
    }

    @Generated
    public double getMaxCpuLoadAvg() {
        return this.maxCpuLoadAvg;
    }

    @Generated
    public double getReservedMemory() {
        return this.reservedMemory;
    }

    @Generated
    public Duration getFailoverInterval() {
        return this.failoverInterval;
    }

    @Generated
    public boolean isKillYarnJobWhenTaskFailover() {
        return this.killYarnJobWhenTaskFailover;
    }

    @Generated
    public ConnectStrategyProperties getRegistryDisconnectStrategy() {
        return this.registryDisconnectStrategy;
    }

    @Generated
    public String getMasterAddress() {
        return this.masterAddress;
    }

    @Generated
    public String getMasterRegistryPath() {
        return this.masterRegistryPath;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setFetchCommandNum(int fetchCommandNum) {
        this.fetchCommandNum = fetchCommandNum;
    }

    @Generated
    public void setPreExecThreads(int preExecThreads) {
        this.preExecThreads = preExecThreads;
    }

    @Generated
    public void setExecThreads(int execThreads) {
        this.execThreads = execThreads;
    }

    @Generated
    public void setDispatchTaskNumber(int dispatchTaskNumber) {
        this.dispatchTaskNumber = dispatchTaskNumber;
    }

    @Generated
    public void setHostSelector(HostSelector hostSelector) {
        this.hostSelector = hostSelector;
    }

    @Generated
    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    @Generated
    public void setTaskCommitRetryTimes(int taskCommitRetryTimes) {
        this.taskCommitRetryTimes = taskCommitRetryTimes;
    }

    @Generated
    public void setTaskCommitInterval(Duration taskCommitInterval) {
        this.taskCommitInterval = taskCommitInterval;
    }

    @Generated
    public void setStateWheelInterval(Duration stateWheelInterval) {
        this.stateWheelInterval = stateWheelInterval;
    }

    @Generated
    public void setMaxCpuLoadAvg(double maxCpuLoadAvg) {
        this.maxCpuLoadAvg = maxCpuLoadAvg;
    }

    @Generated
    public void setReservedMemory(double reservedMemory) {
        this.reservedMemory = reservedMemory;
    }

    @Generated
    public void setFailoverInterval(Duration failoverInterval) {
        this.failoverInterval = failoverInterval;
    }

    @Generated
    public void setKillYarnJobWhenTaskFailover(boolean killYarnJobWhenTaskFailover) {
        this.killYarnJobWhenTaskFailover = killYarnJobWhenTaskFailover;
    }

    @Generated
    public void setRegistryDisconnectStrategy(ConnectStrategyProperties registryDisconnectStrategy) {
        this.registryDisconnectStrategy = registryDisconnectStrategy;
    }

    @Generated
    public void setMasterAddress(String masterAddress) {
        this.masterAddress = masterAddress;
    }

    @Generated
    public void setMasterRegistryPath(String masterRegistryPath) {
        this.masterRegistryPath = masterRegistryPath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterConfig)) {
            return false;
        }
        MasterConfig other = (MasterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListenPort() != other.getListenPort()) {
            return false;
        }
        if (this.getFetchCommandNum() != other.getFetchCommandNum()) {
            return false;
        }
        if (this.getPreExecThreads() != other.getPreExecThreads()) {
            return false;
        }
        if (this.getExecThreads() != other.getExecThreads()) {
            return false;
        }
        if (this.getDispatchTaskNumber() != other.getDispatchTaskNumber()) {
            return false;
        }
        if (this.getTaskCommitRetryTimes() != other.getTaskCommitRetryTimes()) {
            return false;
        }
        if (Double.compare(this.getMaxCpuLoadAvg(), other.getMaxCpuLoadAvg()) != 0) {
            return false;
        }
        if (Double.compare(this.getReservedMemory(), other.getReservedMemory()) != 0) {
            return false;
        }
        if (this.isKillYarnJobWhenTaskFailover() != other.isKillYarnJobWhenTaskFailover()) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        HostSelector this$hostSelector = this.getHostSelector();
        HostSelector other$hostSelector = other.getHostSelector();
        if (this$hostSelector == null ? other$hostSelector != null : !((Object)((Object)this$hostSelector)).equals((Object)other$hostSelector)) {
            return false;
        }
        Duration this$heartbeatInterval = this.getHeartbeatInterval();
        Duration other$heartbeatInterval = other.getHeartbeatInterval();
        if (this$heartbeatInterval == null ? other$heartbeatInterval != null : !((Object)this$heartbeatInterval).equals(other$heartbeatInterval)) {
            return false;
        }
        Duration this$taskCommitInterval = this.getTaskCommitInterval();
        Duration other$taskCommitInterval = other.getTaskCommitInterval();
        if (this$taskCommitInterval == null ? other$taskCommitInterval != null : !((Object)this$taskCommitInterval).equals(other$taskCommitInterval)) {
            return false;
        }
        Duration this$stateWheelInterval = this.getStateWheelInterval();
        Duration other$stateWheelInterval = other.getStateWheelInterval();
        if (this$stateWheelInterval == null ? other$stateWheelInterval != null : !((Object)this$stateWheelInterval).equals(other$stateWheelInterval)) {
            return false;
        }
        Duration this$failoverInterval = this.getFailoverInterval();
        Duration other$failoverInterval = other.getFailoverInterval();
        if (this$failoverInterval == null ? other$failoverInterval != null : !((Object)this$failoverInterval).equals(other$failoverInterval)) {
            return false;
        }
        ConnectStrategyProperties this$registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        ConnectStrategyProperties other$registryDisconnectStrategy = other.getRegistryDisconnectStrategy();
        if (this$registryDisconnectStrategy == null ? other$registryDisconnectStrategy != null : !this$registryDisconnectStrategy.equals(other$registryDisconnectStrategy)) {
            return false;
        }
        String this$masterAddress = this.getMasterAddress();
        String other$masterAddress = other.getMasterAddress();
        if (this$masterAddress == null ? other$masterAddress != null : !this$masterAddress.equals(other$masterAddress)) {
            return false;
        }
        String this$masterRegistryPath = this.getMasterRegistryPath();
        String other$masterRegistryPath = other.getMasterRegistryPath();
        return !(this$masterRegistryPath == null ? other$masterRegistryPath != null : !this$masterRegistryPath.equals(other$masterRegistryPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MasterConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListenPort();
        result = result * 59 + this.getFetchCommandNum();
        result = result * 59 + this.getPreExecThreads();
        result = result * 59 + this.getExecThreads();
        result = result * 59 + this.getDispatchTaskNumber();
        result = result * 59 + this.getTaskCommitRetryTimes();
        long $maxCpuLoadAvg = Double.doubleToLongBits(this.getMaxCpuLoadAvg());
        result = result * 59 + (int)($maxCpuLoadAvg >>> 32 ^ $maxCpuLoadAvg);
        long $reservedMemory = Double.doubleToLongBits(this.getReservedMemory());
        result = result * 59 + (int)($reservedMemory >>> 32 ^ $reservedMemory);
        result = result * 59 + (this.isKillYarnJobWhenTaskFailover() ? 79 : 97);
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        HostSelector $hostSelector = this.getHostSelector();
        result = result * 59 + ($hostSelector == null ? 43 : ((Object)((Object)$hostSelector)).hashCode());
        Duration $heartbeatInterval = this.getHeartbeatInterval();
        result = result * 59 + ($heartbeatInterval == null ? 43 : ((Object)$heartbeatInterval).hashCode());
        Duration $taskCommitInterval = this.getTaskCommitInterval();
        result = result * 59 + ($taskCommitInterval == null ? 43 : ((Object)$taskCommitInterval).hashCode());
        Duration $stateWheelInterval = this.getStateWheelInterval();
        result = result * 59 + ($stateWheelInterval == null ? 43 : ((Object)$stateWheelInterval).hashCode());
        Duration $failoverInterval = this.getFailoverInterval();
        result = result * 59 + ($failoverInterval == null ? 43 : ((Object)$failoverInterval).hashCode());
        ConnectStrategyProperties $registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        result = result * 59 + ($registryDisconnectStrategy == null ? 43 : $registryDisconnectStrategy.hashCode());
        String $masterAddress = this.getMasterAddress();
        result = result * 59 + ($masterAddress == null ? 43 : $masterAddress.hashCode());
        String $masterRegistryPath = this.getMasterRegistryPath();
        result = result * 59 + ($masterRegistryPath == null ? 43 : $masterRegistryPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MasterConfig(logger=" + this.getLogger() + ", listenPort=" + this.getListenPort() + ", fetchCommandNum=" + this.getFetchCommandNum() + ", preExecThreads=" + this.getPreExecThreads() + ", execThreads=" + this.getExecThreads() + ", dispatchTaskNumber=" + this.getDispatchTaskNumber() + ", hostSelector=" + (Object)((Object)this.getHostSelector()) + ", heartbeatInterval=" + this.getHeartbeatInterval() + ", taskCommitRetryTimes=" + this.getTaskCommitRetryTimes() + ", taskCommitInterval=" + this.getTaskCommitInterval() + ", stateWheelInterval=" + this.getStateWheelInterval() + ", maxCpuLoadAvg=" + this.getMaxCpuLoadAvg() + ", reservedMemory=" + this.getReservedMemory() + ", failoverInterval=" + this.getFailoverInterval() + ", killYarnJobWhenTaskFailover=" + this.isKillYarnJobWhenTaskFailover() + ", registryDisconnectStrategy=" + this.getRegistryDisconnectStrategy() + ", masterAddress=" + this.getMasterAddress() + ", masterRegistryPath=" + this.getMasterRegistryPath() + ")";
    }
}

