/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;

@AutoService(value={StateEventHandler.class})
public class TaskRetryStateEventHandler
implements StateEventHandler {
    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException {
        TaskStateEvent taskStateEvent = (TaskStateEvent)stateEvent;
        TaskMetrics.incTaskInstanceByState("retry");
        Map<Long, TaskInstance> waitToRetryTaskInstanceMap = workflowExecuteRunnable.getWaitToRetryTaskInstanceMap();
        TaskInstance taskInstance = waitToRetryTaskInstanceMap.get(taskStateEvent.getTaskCode());
        workflowExecuteRunnable.addTaskToStandByList(taskInstance);
        workflowExecuteRunnable.submitStandByTask();
        waitToRetryTaskInstanceMap.remove(taskStateEvent.getTaskCode());
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.TASK_RETRY;
    }
}

