/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import java.time.Duration;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleException;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.StrategyType;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventQueue;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectStrategy;
import org.apache.dolphinscheduler.server.master.rpc.MasterRPCServer;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="master.registry-disconnect-strategy", name={"strategy"}, havingValue="waiting")
public class MasterWaitingStrategy
implements MasterConnectStrategy {
    private final Logger logger = LoggerFactory.getLogger(MasterWaitingStrategy.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MasterRPCServer masterRPCServer;
    @Autowired
    private WorkflowEventQueue workflowEventQueue;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;

    public void disconnect() {
        try {
            ServerLifeCycleManager.toWaiting();
            this.clearMasterResource();
            Duration maxWaitingTime = this.masterConfig.getRegistryDisconnectStrategy().getMaxWaitingTime();
            try {
                this.logger.info("Master disconnect from registry will try to reconnect in {} s", (Object)maxWaitingTime.getSeconds());
                this.registryClient.connectUntilTimeout(maxWaitingTime);
            }
            catch (RegistryException ex) {
                throw new ServerLifeCycleException(String.format("Waiting to reconnect to registry in %s failed", maxWaitingTime), (Throwable)ex);
            }
        }
        catch (ServerLifeCycleException e) {
            String errorMessage = String.format("Disconnect from registry and change the current status to waiting error, the current server state is %s, will stop the current server", ServerLifeCycleManager.getServerStatus());
            this.logger.error(errorMessage, (Throwable)e);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (RegistryException ex) {
            String errorMessage = "Disconnect from registry and waiting to reconnect failed, will stop the server";
            this.logger.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (Exception ex) {
            String errorMessage = "Disconnect from registry and get an unknown exception, will stop the server";
            this.logger.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
    }

    public void reconnect() {
        try {
            ServerLifeCycleManager.recoverFromWaiting();
            this.reStartMasterResource();
            this.logger.info("Recover from waiting success, the current server status is {}", (Object)ServerLifeCycleManager.getServerStatus());
        }
        catch (Exception e) {
            String errorMessage = String.format("Recover from waiting failed, the current server status is %s, will stop the server", ServerLifeCycleManager.getServerStatus());
            this.logger.error(errorMessage, (Throwable)e);
            this.registryClient.getStoppable().stop(errorMessage);
        }
    }

    public StrategyType getStrategyType() {
        return StrategyType.WAITING;
    }

    private void clearMasterResource() {
        this.masterRPCServer.close();
        this.logger.warn("Master closed RPC server due to lost registry connection");
        this.workflowEventQueue.clearWorkflowEventQueue();
        this.logger.warn("Master clear workflow event queue due to lost registry connection");
        this.processInstanceExecCacheManager.clearCache();
        this.logger.warn("Master clear process instance cache due to lost registry connection");
        this.stateWheelExecuteThread.clearAllTasks();
        this.logger.warn("Master clear all state wheel task due to lost registry connection");
    }

    private void reStartMasterResource() {
        this.masterRPCServer.start();
        this.logger.warn("Master restarted RPC server due to reconnect to registry");
    }
}

