/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.server.master.event.WorkflowEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventHandleError;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventHandleException;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventHandler;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventQueue;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowEventLooper
extends BaseDaemonThread {
    private final Logger logger = LoggerFactory.getLogger(WorkflowEventLooper.class);
    @Autowired
    private WorkflowEventQueue workflowEventQueue;
    @Autowired
    private List<WorkflowEventHandler> workflowEventHandlerList;
    private final Map<WorkflowEventType, WorkflowEventHandler> workflowEventHandlerMap = new HashMap<WorkflowEventType, WorkflowEventHandler>();

    protected WorkflowEventLooper() {
        super("WorkflowEventLooper");
    }

    @PostConstruct
    public void init() {
        this.workflowEventHandlerList.forEach(workflowEventHandler -> this.workflowEventHandlerMap.put(workflowEventHandler.getHandleWorkflowEventType(), (WorkflowEventHandler)workflowEventHandler));
    }

    public synchronized void start() {
        this.logger.info("WorkflowEventLooper thread starting");
        super.start();
        this.logger.info("WorkflowEventLooper thread started");
    }

    public void run() {
        WorkflowEvent workflowEvent = null;
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                workflowEvent = this.workflowEventQueue.poolEvent();
                LoggerUtils.setWorkflowInstanceIdMDC((int)workflowEvent.getWorkflowInstanceId());
                this.logger.info("Workflow event looper receive a workflow event: {}, will handle this", (Object)workflowEvent);
                WorkflowEventHandler workflowEventHandler = this.workflowEventHandlerMap.get((Object)workflowEvent.getWorkflowEventType());
                workflowEventHandler.handleWorkflowEvent(workflowEvent);
            }
            catch (InterruptedException e) {
                this.logger.warn("WorkflowEventLooper thread is interrupted, will close this loop", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
            catch (WorkflowEventHandleException workflowEventHandleException) {
                this.logger.error("Handle workflow event failed, will add this event to event queue again, event: {}", (Object)workflowEvent, (Object)workflowEventHandleException);
                this.workflowEventQueue.addEvent(workflowEvent);
                ThreadUtils.sleep((long)1000L);
            }
            catch (WorkflowEventHandleError workflowEventHandleError) {
                this.logger.error("Handle workflow event error, will drop this event, event: {}", (Object)workflowEvent, (Object)workflowEventHandleError);
            }
            catch (Exception unknownException) {
                this.logger.error("Handle workflow event failed, get a unknown exception, will add this event to event queue again, event: {}", (Object)workflowEvent, (Object)unknownException);
                this.workflowEventQueue.addEvent(workflowEvent);
                ThreadUtils.sleep((long)1000L);
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }
}

