/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.auto.service.AutoService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.remote.command.TaskKillRequestCommand;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.enums.ExecutorType;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.ExecuteException;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.queue.TaskPriority;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueueImpl;

@AutoService(value={ITaskProcessor.class})
public class CommonTaskProcessor
extends BaseTaskProcessor {
    private TaskPriorityQueue<TaskPriority> taskUpdateQueue;
    private NettyExecutorManager nettyExecutorManager = (NettyExecutorManager)SpringApplicationContext.getBean(NettyExecutorManager.class);

    @Override
    protected boolean submitTask() {
        this.taskInstance = this.processService.submitTaskWithRetry(this.processInstance, this.taskInstance, this.maxRetryTimes, this.commitInterval);
        return this.taskInstance != null;
    }

    @Override
    protected boolean resubmitTask() {
        if (this.taskInstance == null) {
            return false;
        }
        this.setTaskExecutionLogger();
        return this.dispatchTask();
    }

    @Override
    public boolean runTask() {
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        return true;
    }

    @Override
    protected boolean pauseTask() {
        return true;
    }

    @Override
    public String getType() {
        return "common";
    }

    @Override
    public boolean dispatchTask() {
        try {
            if (this.taskUpdateQueue == null) {
                this.initQueue();
            }
            if (this.taskInstance.getState().isFinished()) {
                this.logger.info("submit task , but task [{}] state [{}] is already  finished. ", (Object)this.taskInstance.getName(), (Object)this.taskInstance.getState());
                return true;
            }
            if (this.taskInstance.getState() == TaskExecutionStatus.RUNNING_EXECUTION || this.taskInstance.getState() == TaskExecutionStatus.DELAY_EXECUTION) {
                this.logger.info("submit task, but the status of the task {} is already running or delayed.", (Object)this.taskInstance.getName());
                return true;
            }
            this.logger.info("task ready to dispatch to worker: taskInstanceId: {}", (Object)this.taskInstance.getId());
            TaskPriority taskPriority = new TaskPriority(this.processInstance.getProcessInstancePriority().getCode(), this.processInstance.getId().intValue(), this.taskInstance.getProcessInstancePriority().getCode(), this.taskInstance.getId().intValue(), this.taskInstance.getTaskGroupPriority(), "default");
            TaskExecutionContext taskExecutionContext = this.getTaskExecutionContext(this.taskInstance);
            if (taskExecutionContext == null) {
                this.logger.error("task get taskExecutionContext fail: {}", (Object)this.taskInstance);
                return false;
            }
            taskPriority.setTaskExecutionContext(taskExecutionContext);
            this.taskUpdateQueue.put((Object)taskPriority);
            this.logger.info("Master submit task to priority queue success, taskInstanceId : {}", (Object)this.taskInstance.getId());
            return true;
        }
        catch (Exception e) {
            this.logger.error("submit task error", (Throwable)e);
            return false;
        }
    }

    public void initQueue() {
        this.taskUpdateQueue = (TaskPriorityQueue)SpringApplicationContext.getBean(TaskPriorityQueueImpl.class);
    }

    @Override
    public boolean killTask() {
        try {
            this.taskInstance = this.processService.findTaskInstanceById(this.taskInstance.getId());
            if (this.taskInstance == null) {
                return true;
            }
            if (this.taskInstance.getState().isFinished()) {
                return true;
            }
            this.taskInstance.setState(TaskExecutionStatus.KILL);
            this.taskInstance.setEndTime(new Date());
            this.processService.updateTaskInstance(this.taskInstance);
            if (StringUtils.isNotEmpty((CharSequence)this.taskInstance.getHost())) {
                this.killRemoteTask();
            }
        }
        catch (Exception e) {
            this.logger.error("master kill task error, taskInstance id: {}", (Object)this.taskInstance.getId(), (Object)e);
            return false;
        }
        this.logger.info("master success kill taskInstance name: {} taskInstance id: {}", (Object)this.taskInstance.getName(), (Object)this.taskInstance.getId());
        return true;
    }

    private void killRemoteTask() throws ExecuteException {
        TaskKillRequestCommand killCommand = new TaskKillRequestCommand();
        killCommand.setTaskInstanceId(this.taskInstance.getId().intValue());
        ExecutionContext executionContext = new ExecutionContext(killCommand.convert2Command(), ExecutorType.WORKER, this.taskInstance);
        Host host = Host.of((String)this.taskInstance.getHost());
        executionContext.setHost(host);
        this.nettyExecutorManager.executeDirectly(executionContext);
    }
}

