/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.utils.DependentExecute;
import org.apache.dolphinscheduler.server.utils.LogUtils;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;

@AutoService(value={ITaskProcessor.class})
public class DependentTaskProcessor
extends BaseTaskProcessor {
    private DependentParameters dependentParameters;
    private final ProcessDefinitionMapper processDefinitionMapper = (ProcessDefinitionMapper)SpringApplicationContext.getBean(ProcessDefinitionMapper.class);
    private final TaskDefinitionMapper taskDefinitionMapper = (TaskDefinitionMapper)SpringApplicationContext.getBean(TaskDefinitionMapper.class);
    private final ProjectMapper projectMapper = (ProjectMapper)SpringApplicationContext.getBean(ProjectMapper.class);
    private List<DependentExecute> dependentTaskList = new ArrayList<DependentExecute>();
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    private Map<Long, Project> projectCodeMap = new HashMap<Long, Project>();
    private Map<Long, ProcessDefinition> processDefinitionMap = new HashMap<Long, ProcessDefinition>();
    private Map<Long, TaskDefinition> taskDefinitionMap = new HashMap<Long, TaskDefinition>();
    private Date dependentDate;
    DependResult result;
    boolean allDependentItemFinished;

    @Override
    public boolean submitTask() {
        try {
            this.taskInstance = this.processService.submitTaskWithRetry(this.processInstance, this.taskInstance, this.maxRetryTimes, this.commitInterval);
            if (this.taskInstance == null) {
                return false;
            }
            this.setTaskExecutionLogger();
            this.logger.info("Dependent task submit success");
            this.taskInstance.setLogPath(LogUtils.getTaskLogPath((Date)this.taskInstance.getFirstSubmitTime(), (Long)this.processInstance.getProcessDefinitionCode(), (int)this.processInstance.getProcessDefinitionVersion(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId()));
            this.taskInstance.setHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
            this.taskInstance.setState(TaskExecutionStatus.RUNNING_EXECUTION);
            this.taskInstance.setStartTime(new Date());
            this.processService.updateTaskInstance(this.taskInstance);
            this.initDependParameters();
            this.logger.info("Success initialize dependent task parameters, the dependent data is: {}", (Object)this.dependentDate);
            return true;
        }
        catch (Exception ex) {
            this.logger.error("Submit/Initialize dependent task error", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean runTask() {
        if (!this.allDependentItemFinished) {
            this.allDependentItemFinished = this.allDependentTaskFinish();
        }
        if (this.allDependentItemFinished) {
            this.getTaskDependResult();
            this.endTask();
        }
        return true;
    }

    @Override
    protected boolean resubmitTask() {
        return true;
    }

    @Override
    protected boolean dispatchTask() {
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        TaskTimeoutStrategy taskTimeoutStrategy = this.taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        if (TaskTimeoutStrategy.FAILED != taskTimeoutStrategy && TaskTimeoutStrategy.WARNFAILED != taskTimeoutStrategy) {
            return true;
        }
        this.logger.info("dependent taskInstanceId: {} timeout, taskName: {}, strategy: {} ", new Object[]{this.taskInstance.getId(), this.taskInstance.getName(), taskTimeoutStrategy.getDescp()});
        this.result = DependResult.FAILED;
        this.endTask();
        return true;
    }

    private void initDependParameters() {
        this.dependentParameters = this.taskInstance.getDependency();
        this.dependentDate = this.processInstance.getScheduleTime() != null ? this.processInstance.getScheduleTime() : new Date();
        List dependTaskList = this.dependentParameters.getDependTaskList();
        HashSet projectCodes = new HashSet();
        HashSet processDefinitionCodes = new HashSet();
        HashSet taskDefinitionCodes = new HashSet();
        dependTaskList.forEach(dependentTaskModel -> dependentTaskModel.getDependItemList().forEach(dependentItem -> {
            projectCodes.add(dependentItem.getProjectCode());
            processDefinitionCodes.add(dependentItem.getDefinitionCode());
            taskDefinitionCodes.add(dependentItem.getDepTaskCode());
        }));
        this.projectCodeMap = this.projectMapper.queryByCodes(projectCodes).stream().collect(Collectors.toMap(Project::getCode, Function.identity()));
        this.processDefinitionMap = this.processDefinitionMapper.queryByCodes(processDefinitionCodes).stream().collect(Collectors.toMap(ProcessDefinition::getCode, Function.identity()));
        this.taskDefinitionMap = this.taskDefinitionMapper.queryByCodeList(taskDefinitionCodes).stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity()));
        for (DependentTaskModel taskModel : this.dependentParameters.getDependTaskList()) {
            this.logger.info("Add sub dependent check tasks, dependent relation: {}", (Object)taskModel.getRelation());
            for (DependentItem dependentItem : taskModel.getDependItemList()) {
                Project project = this.projectCodeMap.get(dependentItem.getProjectCode());
                if (project == null) {
                    this.logger.error("The dependent task's project is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's project is not exist, dependentItem: " + dependentItem);
                }
                ProcessDefinition processDefinition = this.processDefinitionMap.get(dependentItem.getDefinitionCode());
                if (processDefinition == null) {
                    this.logger.error("The dependent task's workflow is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's workflow is not exist, dependentItem: " + dependentItem);
                }
                if (dependentItem.getDepTaskCode() == 0L) {
                    this.logger.info("Add dependent task: projectName: {}, workflowName: {}, taskName: ALL, dependentKey: {}", new Object[]{project.getName(), processDefinition.getName(), dependentItem.getKey()});
                    continue;
                }
                TaskDefinition taskDefinition = this.taskDefinitionMap.get(dependentItem.getDepTaskCode());
                if (taskDefinition == null) {
                    this.logger.error("The dependent task's taskDefinition is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's taskDefinition is not exist, dependentItem: " + dependentItem);
                }
                this.logger.info("Add dependent task: projectName: {}, workflowName: {}, taskName: {}, dependentKey: {}", new Object[]{project.getName(), processDefinition.getName(), taskDefinition.getName(), dependentItem.getKey()});
            }
            this.dependentTaskList.add(new DependentExecute(taskModel.getDependItemList(), taskModel.getRelation()));
        }
    }

    @Override
    protected boolean pauseTask() {
        this.taskInstance.setState(TaskExecutionStatus.PAUSE);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean killTask() {
        this.taskInstance.setState(TaskExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    private boolean allDependentTaskFinish() {
        boolean finish = true;
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            for (Map.Entry<String, DependResult> entry : dependentExecute.getDependResultMap().entrySet()) {
                if (this.dependResultMap.containsKey(entry.getKey())) continue;
                this.dependResultMap.put(entry.getKey(), entry.getValue());
                this.logger.info("dependent item complete, dependentKey: {}, result: {}, dependentDate: {}", new Object[]{entry.getKey(), entry.getValue(), this.dependentDate});
            }
            if (dependentExecute.finish(this.dependentDate)) continue;
            finish = false;
        }
        return finish;
    }

    private DependResult getTaskDependResult() {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            DependResult dependResult = dependentExecute.getModelDependResult(this.dependentDate);
            dependResultList.add(dependResult);
        }
        this.result = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), dependResultList);
        this.logger.info("Dependent task completed, dependent result: {}", (Object)this.result);
        return this.result;
    }

    private void endTask() {
        TaskExecutionStatus status = this.result == DependResult.SUCCESS ? TaskExecutionStatus.SUCCESS : TaskExecutionStatus.FAILURE;
        this.taskInstance.setState(status);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
    }

    @Override
    public String getType() {
        return "DEPENDENT";
    }
}

