/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.server.master.runner.task.TaskInstanceKey;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class StateWheelExecuteThread
extends BaseDaemonThread {
    private static final Logger logger = LoggerFactory.getLogger(StateWheelExecuteThread.class);
    private final ConcurrentLinkedQueue<Integer> processInstanceTimeoutCheckList = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<TaskInstanceKey> taskInstanceTimeoutCheckList = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<TaskInstanceKey> taskInstanceRetryCheckList = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<TaskInstanceKey> taskInstanceStateCheckList = new ConcurrentLinkedQueue();
    @Autowired
    private MasterConfig masterConfig;
    @Lazy
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;

    protected StateWheelExecuteThread() {
        super("StateWheelExecuteThread");
    }

    @PostConstruct
    public void startWheelThread() {
        super.start();
    }

    public void run() {
        long checkInterval = this.masterConfig.getStateWheelInterval().toMillis();
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                this.checkTask4Timeout();
                this.checkTask4Retry();
                this.checkTask4State();
                this.checkProcess4Timeout();
            }
            catch (Exception e) {
                logger.error("state wheel thread check error:", (Throwable)e);
            }
            try {
                Thread.sleep(checkInterval);
            }
            catch (InterruptedException e) {
                logger.error("state wheel thread sleep error, will close the loop", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void addProcess4TimeoutCheck(ProcessInstance processInstance) {
        this.processInstanceTimeoutCheckList.add(processInstance.getId());
        logger.info("Success add workflow instance {} into timeout check list", (Object)processInstance.getId());
    }

    public void removeProcess4TimeoutCheck(int processInstanceId) {
        boolean removeFlag = this.processInstanceTimeoutCheckList.remove(processInstanceId);
        if (removeFlag) {
            logger.info("Success remove workflow instance {} from timeout check list", (Object)processInstanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProcess4Timeout() {
        if (this.processInstanceTimeoutCheckList.isEmpty()) {
            return;
        }
        for (Integer processInstanceId : this.processInstanceTimeoutCheckList) {
            try {
                LoggerUtils.setWorkflowInstanceIdMDC((int)processInstanceId);
                WorkflowExecuteRunnable workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(processInstanceId);
                if (workflowExecuteThread == null) {
                    logger.warn("Check workflow timeout failed, can not find workflowExecuteThread from cache manager, will remove this workflowInstance from check list");
                    this.processInstanceTimeoutCheckList.remove(processInstanceId);
                    continue;
                }
                ProcessInstance processInstance = workflowExecuteThread.getProcessInstance();
                if (processInstance == null) {
                    logger.warn("Check workflow timeout failed, the workflowInstance is null");
                    continue;
                }
                long timeRemain = DateUtils.getRemainTime((Date)processInstance.getStartTime(), (long)((long)processInstance.getTimeout() * 60L));
                if (timeRemain >= 0L) continue;
                logger.info("Workflow instance {} timeout, adding timeout event", (Object)processInstance.getId());
                this.addProcessTimeoutEvent(processInstance);
                this.processInstanceTimeoutCheckList.remove(processInstance.getId());
                logger.info("Workflow instance timeout, added timeout event");
            }
            catch (Exception ex) {
                logger.error("Check workflow instance timeout error");
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }

    public void addTask4TimeoutCheck(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        TaskInstanceKey taskInstanceKey = TaskInstanceKey.getTaskInstanceKey(processInstance, taskInstance);
        logger.info("Adding task instance into timeout check list");
        if (this.taskInstanceTimeoutCheckList.contains(taskInstanceKey)) {
            logger.warn("Task instance is already in timeout check list");
            return;
        }
        TaskDefinition taskDefinition = taskInstance.getTaskDefine();
        if (taskDefinition == null) {
            logger.error("Failed to add task instance into timeout check list, taskDefinition is null");
            return;
        }
        if (TimeoutFlag.OPEN == taskDefinition.getTimeoutFlag()) {
            this.taskInstanceTimeoutCheckList.add(taskInstanceKey);
            logger.info("Timeout flag is open, added task instance into timeout check list");
        }
        if (taskInstance.isDependTask() || taskInstance.isSubProcess()) {
            this.taskInstanceTimeoutCheckList.add(taskInstanceKey);
            logger.info("task instance is dependTask orSubProcess, added task instance into timeout check list");
        }
    }

    public void removeTask4TimeoutCheck(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        TaskInstanceKey taskInstanceKey = TaskInstanceKey.getTaskInstanceKey(processInstance, taskInstance);
        this.taskInstanceTimeoutCheckList.remove(taskInstanceKey);
        logger.info("remove task instance from timeout check list");
    }

    public void addTask4RetryCheck(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        logger.info("Adding task instance into retry check list");
        TaskInstanceKey taskInstanceKey = TaskInstanceKey.getTaskInstanceKey(processInstance, taskInstance);
        if (this.taskInstanceRetryCheckList.contains(taskInstanceKey)) {
            logger.warn("Task instance is already in retry check list");
            return;
        }
        TaskDefinition taskDefinition = taskInstance.getTaskDefine();
        if (taskDefinition == null) {
            logger.error("Add task instance into retry check list error, taskDefinition is null");
            return;
        }
        this.taskInstanceRetryCheckList.add(taskInstanceKey);
        logger.info("[WorkflowInstance-{}][TaskInstance-{}] Added task instance into retry check list", (Object)processInstance.getId(), (Object)taskInstance.getId());
    }

    public void removeTask4RetryCheck(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        TaskInstanceKey taskInstanceKey = TaskInstanceKey.getTaskInstanceKey(processInstance, taskInstance);
        this.taskInstanceRetryCheckList.remove(taskInstanceKey);
        logger.info("remove task instance from retry check list");
    }

    public void addTask4StateCheck(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        logger.info("Adding task instance into state check list");
        TaskInstanceKey taskInstanceKey = TaskInstanceKey.getTaskInstanceKey(processInstance, taskInstance);
        if (this.taskInstanceStateCheckList.contains(taskInstanceKey)) {
            logger.warn("Task instance is already in state check list");
            return;
        }
        if (taskInstance.isDependTask() || taskInstance.isSubProcess()) {
            this.taskInstanceStateCheckList.add(taskInstanceKey);
            logger.info("Added task instance into state check list");
        }
    }

    public void removeTask4StateCheck(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        TaskInstanceKey taskInstanceKey = TaskInstanceKey.getTaskInstanceKey(processInstance, taskInstance);
        this.taskInstanceStateCheckList.remove(taskInstanceKey);
        logger.info("Removed task instance from state check list");
    }

    public void clearAllTasks() {
        this.processInstanceTimeoutCheckList.clear();
        this.taskInstanceTimeoutCheckList.clear();
        this.taskInstanceRetryCheckList.clear();
        this.taskInstanceStateCheckList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTask4Timeout() {
        if (this.taskInstanceTimeoutCheckList.isEmpty()) {
            return;
        }
        for (TaskInstanceKey taskInstanceKey : this.taskInstanceTimeoutCheckList) {
            try {
                long timeRemain;
                int processInstanceId = taskInstanceKey.getProcessInstanceId();
                LoggerUtils.setWorkflowInstanceIdMDC((int)processInstanceId);
                long taskCode = taskInstanceKey.getTaskCode();
                WorkflowExecuteRunnable workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(processInstanceId);
                if (workflowExecuteThread == null) {
                    logger.warn("Check task instance timeout failed, can not find workflowExecuteThread from cache manager, will remove this check task");
                    this.taskInstanceTimeoutCheckList.remove(taskInstanceKey);
                    continue;
                }
                Optional<TaskInstance> taskInstanceOptional = workflowExecuteThread.getActiveTaskInstanceByTaskCode(taskCode);
                if (!taskInstanceOptional.isPresent()) {
                    logger.warn("Check task instance timeout failed, can not get taskInstance from workflowExecuteThread, taskCode: {}will remove this check task", (Object)taskCode);
                    this.taskInstanceTimeoutCheckList.remove(taskInstanceKey);
                    continue;
                }
                TaskInstance taskInstance = taskInstanceOptional.get();
                if (TimeoutFlag.OPEN != taskInstance.getTaskDefine().getTimeoutFlag() || (timeRemain = DateUtils.getRemainTime((Date)taskInstance.getStartTime(), (long)((long)taskInstance.getTaskDefine().getTimeout() * 60L))) >= 0L) continue;
                logger.info("Task instance is timeout, adding task timeout event and remove the check");
                this.addTaskTimeoutEvent(taskInstance);
                this.taskInstanceTimeoutCheckList.remove(taskInstanceKey);
            }
            catch (Exception ex) {
                logger.error("Check task timeout error, taskInstanceKey: {}", (Object)taskInstanceKey, (Object)ex);
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTask4Retry() {
        if (this.taskInstanceRetryCheckList.isEmpty()) {
            return;
        }
        for (TaskInstanceKey taskInstanceKey : this.taskInstanceRetryCheckList) {
            int processInstanceId = taskInstanceKey.getProcessInstanceId();
            long taskCode = taskInstanceKey.getTaskCode();
            try {
                LoggerUtils.setWorkflowInstanceIdMDC((int)processInstanceId);
                WorkflowExecuteRunnable workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(processInstanceId);
                if (workflowExecuteThread == null) {
                    logger.warn("Task instance retry check failed, can not find workflowExecuteThread from cache manager, will remove this check task");
                    this.taskInstanceRetryCheckList.remove(taskInstanceKey);
                    continue;
                }
                Optional<TaskInstance> taskInstanceOptional = workflowExecuteThread.getRetryTaskInstanceByTaskCode(taskCode);
                ProcessInstance processInstance = workflowExecuteThread.getProcessInstance();
                if (processInstance.getState().isReadyStop()) {
                    logger.warn("The process instance is ready to stop, will send process stop event and remove the check task");
                    this.addProcessStopEvent(processInstance);
                    this.taskInstanceRetryCheckList.remove(taskInstanceKey);
                    break;
                }
                if (!taskInstanceOptional.isPresent()) {
                    logger.warn("Task instance retry check failed, can not find taskInstance from workflowExecuteThread, will remove this check");
                    this.taskInstanceRetryCheckList.remove(taskInstanceKey);
                    continue;
                }
                TaskInstance taskInstance = taskInstanceOptional.get();
                if (taskInstance.getState() == TaskExecutionStatus.NEED_FAULT_TOLERANCE || !taskInstance.retryTaskIntervalOverTime()) continue;
                logger.info("[TaskInstance-{}]The task instance can retry, will retry this task instance", (Object)taskInstance.getId());
                taskInstance.setEndTime(null);
                taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
                this.addTaskRetryEvent(taskInstance);
                this.taskInstanceRetryCheckList.remove(taskInstanceKey);
            }
            catch (Exception ex) {
                logger.error("Check task retry error, taskInstanceKey: {}", (Object)taskInstanceKey, (Object)ex);
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTask4State() {
        if (this.taskInstanceStateCheckList.isEmpty()) {
            return;
        }
        for (TaskInstanceKey taskInstanceKey : this.taskInstanceStateCheckList) {
            int processInstanceId = taskInstanceKey.getProcessInstanceId();
            long taskCode = taskInstanceKey.getTaskCode();
            try {
                LoggerUtils.setTaskInstanceIdMDC((int)processInstanceId);
                WorkflowExecuteRunnable workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(processInstanceId);
                if (workflowExecuteThread == null) {
                    logger.warn("Task instance state check failed, can not find workflowExecuteThread from cache manager, will remove this check task");
                    this.taskInstanceStateCheckList.remove(taskInstanceKey);
                    continue;
                }
                Optional<TaskInstance> taskInstanceOptional = workflowExecuteThread.getActiveTaskInstanceByTaskCode(taskCode);
                if (!taskInstanceOptional.isPresent()) {
                    logger.warn("Task instance state check failed, can not find taskInstance from workflowExecuteThread, will remove this check event");
                    this.taskInstanceStateCheckList.remove(taskInstanceKey);
                    continue;
                }
                TaskInstance taskInstance = taskInstanceOptional.get();
                if (taskInstance.getState().isFinished()) continue;
                this.addTaskStateChangeEvent(taskInstance);
            }
            catch (Exception ex) {
                logger.error("Task state check error, taskInstanceKey: {}", (Object)taskInstanceKey, (Object)ex);
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }

    private void addTaskStateChangeEvent(TaskInstance taskInstance) {
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(taskInstance.getProcessInstanceId()).taskInstanceId(taskInstance.getId()).taskCode(taskInstance.getTaskCode()).type(StateEventType.TASK_STATE_CHANGE).status(TaskExecutionStatus.RUNNING_EXECUTION).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    private void addProcessStopEvent(ProcessInstance processInstance) {
        WorkflowStateEvent stateEvent = WorkflowStateEvent.builder().processInstanceId(processInstance.getId()).type(StateEventType.PROCESS_STATE_CHANGE).status(WorkflowExecutionStatus.STOP).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    private void addTaskRetryEvent(TaskInstance taskInstance) {
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(taskInstance.getProcessInstanceId()).taskInstanceId(taskInstance.getId()).taskCode(taskInstance.getTaskCode()).status(TaskExecutionStatus.RUNNING_EXECUTION).type(StateEventType.TASK_RETRY).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    private void addTaskTimeoutEvent(TaskInstance taskInstance) {
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(taskInstance.getProcessInstanceId()).taskInstanceId(taskInstance.getId()).type(StateEventType.TASK_TIMEOUT).taskCode(taskInstance.getTaskCode()).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    private void addProcessTimeoutEvent(ProcessInstance processInstance) {
        WorkflowStateEvent stateEvent = WorkflowStateEvent.builder().processInstanceId(processInstance.getId()).type(StateEventType.PROCESS_TIMEOUT).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }
}

