/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.remote.command.WorkflowStateEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.StateEventCallbackService;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
public class WorkflowExecuteThreadPool
extends ThreadPoolTaskExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowExecuteThreadPool.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StateEventCallbackService stateEventCallbackService;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;
    private ConcurrentHashMap<String, WorkflowExecuteRunnable> multiThreadFilterMap = new ConcurrentHashMap();

    @PostConstruct
    private void init() {
        this.setDaemon(true);
        this.setThreadNamePrefix("WorkflowExecuteThread-");
        this.setMaxPoolSize(this.masterConfig.getExecThreads());
        this.setCorePoolSize(this.masterConfig.getExecThreads());
    }

    public void submitStateEvent(StateEvent stateEvent) {
        WorkflowExecuteRunnable workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(stateEvent.getProcessInstanceId());
        if (workflowExecuteThread == null) {
            logger.warn("Submit state event error, cannot from workflowExecuteThread from cache manager, stateEvent:{}", (Object)stateEvent);
            return;
        }
        workflowExecuteThread.addStateEvent(stateEvent);
        logger.info("Submit state event success, stateEvent: {}", (Object)stateEvent);
    }

    public void executeEvent(final WorkflowExecuteRunnable workflowExecuteThread) {
        if (!workflowExecuteThread.isStart() || workflowExecuteThread.eventSize() == 0) {
            return;
        }
        if (this.multiThreadFilterMap.containsKey(workflowExecuteThread.getKey())) {
            logger.warn("The workflow has been executed by another thread");
            return;
        }
        this.multiThreadFilterMap.put(workflowExecuteThread.getKey(), workflowExecuteThread);
        final int processInstanceId = workflowExecuteThread.getProcessInstance().getId();
        ListenableFuture future = this.submitListenable(workflowExecuteThread::handleEvents);
        future.addCallback(new ListenableFutureCallback(){

            public void onFailure(Throwable ex) {
                LoggerUtils.setWorkflowInstanceIdMDC((int)processInstanceId);
                try {
                    logger.error("Workflow instance events handle failed", ex);
                    WorkflowExecuteThreadPool.this.multiThreadFilterMap.remove(workflowExecuteThread.getKey());
                }
                finally {
                    LoggerUtils.removeWorkflowInstanceIdMDC();
                }
            }

            public void onSuccess(Object result) {
                try {
                    LoggerUtils.setWorkflowInstanceIdMDC((int)workflowExecuteThread.getProcessInstance().getId());
                    if (workflowExecuteThread.workFlowFinish()) {
                        WorkflowExecuteThreadPool.this.stateWheelExecuteThread.removeProcess4TimeoutCheck(workflowExecuteThread.getProcessInstance().getId());
                        WorkflowExecuteThreadPool.this.processInstanceExecCacheManager.removeByProcessInstanceId(processInstanceId);
                        WorkflowExecuteThreadPool.this.notifyProcessChanged(workflowExecuteThread.getProcessInstance());
                        logger.info("Workflow instance is finished.");
                    }
                }
                catch (Exception e) {
                    logger.error("Workflow instance is finished, but notify changed error", (Throwable)e);
                }
                finally {
                    WorkflowExecuteThreadPool.this.multiThreadFilterMap.remove(workflowExecuteThread.getKey());
                    LoggerUtils.removeWorkflowInstanceIdMDC();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProcessChanged(ProcessInstance finishProcessInstance) {
        if (Flag.NO == finishProcessInstance.getIsSubProcess()) {
            return;
        }
        Map fatherMaps = this.processService.notifyProcessList(finishProcessInstance.getId().intValue());
        for (Map.Entry entry : fatherMaps.entrySet()) {
            ProcessInstance processInstance = (ProcessInstance)entry.getKey();
            TaskInstance taskInstance = (TaskInstance)entry.getValue();
            String address = NetUtils.getAddr((int)this.masterConfig.getListenPort());
            try {
                LoggerUtils.setWorkflowAndTaskInstanceIDMDC((int)processInstance.getId(), (int)taskInstance.getId());
                if (processInstance.getHost().equalsIgnoreCase(address)) {
                    logger.info("Process host is local master, will notify it");
                    this.notifyMyself(processInstance, taskInstance);
                    continue;
                }
                logger.info("Process host is remote master, will notify it");
                this.notifyProcess(finishProcessInstance, processInstance, taskInstance);
            }
            finally {
                LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
            }
        }
    }

    private void notifyMyself(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        if (!this.processInstanceExecCacheManager.contains(processInstance.getId())) {
            logger.warn("The execute cache manager doesn't contains this workflow instance");
            return;
        }
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(processInstance.getId()).taskInstanceId(taskInstance.getId()).type(StateEventType.TASK_STATE_CHANGE).status(TaskExecutionStatus.RUNNING_EXECUTION).build();
        this.submitStateEvent(stateEvent);
    }

    private void notifyProcess(ProcessInstance finishProcessInstance, ProcessInstance processInstance, TaskInstance taskInstance) {
        String processInstanceHost = processInstance.getHost();
        if (Strings.isNullOrEmpty((String)processInstanceHost)) {
            logger.error("Process {} host is empty, cannot notify task {} now, taskId: {}", new Object[]{processInstance.getName(), taskInstance.getName(), taskInstance.getId()});
            return;
        }
        WorkflowStateEventChangeCommand workflowStateEventChangeCommand = new WorkflowStateEventChangeCommand(finishProcessInstance.getId().intValue(), 0, finishProcessInstance.getState(), processInstance.getId().intValue(), taskInstance.getId().intValue());
        Host host = new Host(processInstanceHost);
        this.stateEventCallbackService.sendResult(host, workflowStateEventChangeCommand.convert2Command());
    }
}

