/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.StateEventResponseService;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskEventProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskEventProcessor.class);
    @Autowired
    private StateEventResponseService stateEventResponseService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_FORCE_STATE_EVENT_REQUEST == command.getType() || CommandType.TASK_WAKEUP_EVENT_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type: %s", command.getType()));
        TaskEventChangeCommand taskEventChangeCommand = (TaskEventChangeCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskEventChangeCommand.class);
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(taskEventChangeCommand.getProcessInstanceId()).taskInstanceId(taskEventChangeCommand.getTaskInstanceId()).key(taskEventChangeCommand.getKey()).type(StateEventType.WAIT_TASK_GROUP).build();
        try {
            LoggerUtils.setWorkflowAndTaskInstanceIDMDC((Integer)stateEvent.getProcessInstanceId(), (Integer)stateEvent.getTaskInstanceId());
            this.logger.info("Received task event change command, event: {}", (Object)stateEvent);
            this.stateEventResponseService.addEvent2WorkflowExecute(stateEvent);
        }
        finally {
            LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

