/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.util.Optional;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.WorkflowExecutingDataRequestCommand;
import org.apache.dolphinscheduler.remote.command.WorkflowExecutingDataResponseCommand;
import org.apache.dolphinscheduler.remote.dto.WorkflowExecuteDto;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.service.ExecutingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowExecutingDataRequestProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(WorkflowExecutingDataRequestProcessor.class);
    @Autowired
    private ExecutingService executingService;

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.WORKFLOW_EXECUTING_DATA_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type: %s", command.getType()));
        WorkflowExecutingDataRequestCommand requestCommand = (WorkflowExecutingDataRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), WorkflowExecutingDataRequestCommand.class);
        this.logger.info("received command, processInstanceId:{}", (Object)requestCommand.getProcessInstanceId());
        Optional<WorkflowExecuteDto> workflowExecuteDtoOptional = this.executingService.queryWorkflowExecutingData(requestCommand.getProcessInstanceId());
        WorkflowExecutingDataResponseCommand responseCommand = new WorkflowExecutingDataResponseCommand();
        workflowExecuteDtoOptional.ifPresent(arg_0 -> ((WorkflowExecutingDataResponseCommand)responseCommand).setWorkflowExecuteDto(arg_0));
        channel.writeAndFlush((Object)responseCommand.convert2Command(command.getOpaque()));
    }
}

