/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class WorkflowTimeoutStateEventHandler
implements StateEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowTimeoutStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) {
        logger.info("Handle workflow instance timeout event");
        ProcessInstanceMetrics.incProcessInstanceByState("timeout");
        workflowExecuteRunnable.processTimeout();
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.PROCESS_TIMEOUT;
    }
}

