/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.host.CommonHostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWeight;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWorker;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.LowerWeightRoundRobin;
import org.apache.dolphinscheduler.server.master.registry.WorkerInfoChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowerWeightHostManager
extends CommonHostManager {
    private final Logger logger = LoggerFactory.getLogger(LowerWeightHostManager.class);
    private LowerWeightRoundRobin selector;
    private ConcurrentHashMap<String, Set<HostWeight>> workerHostWeightsMap;
    private Lock lock;

    @PostConstruct
    public void init() {
        this.selector = new LowerWeightRoundRobin();
        this.workerHostWeightsMap = new ConcurrentHashMap();
        this.lock = new ReentrantLock();
        this.serverNodeManager.addWorkerInfoChangeListener(new WorkerWeightListener());
    }

    @Override
    public Host select(ExecutionContext context) {
        Set<HostWeight> workerHostWeights = this.getWorkerHostWeights(context.getWorkerGroup());
        if (CollectionUtils.isNotEmpty(workerHostWeights)) {
            return this.selector.select(workerHostWeights).getHost();
        }
        return new Host();
    }

    @Override
    public HostWorker select(Collection<HostWorker> nodes) {
        throw new UnsupportedOperationException("not support");
    }

    private void syncWorkerResources(Map<String, Set<String>> workerGroupNodes, Map<String, WorkerHeartBeat> workerNodeInfoMap) {
        try {
            HashMap<String, Set<HostWeight>> workerHostWeights = new HashMap<String, Set<HostWeight>>();
            for (Map.Entry<String, Set<String>> entry : workerGroupNodes.entrySet()) {
                String workerGroup = entry.getKey();
                Set<String> nodes = entry.getValue();
                HashSet hostWeights = new HashSet(nodes.size());
                for (String node : nodes) {
                    WorkerHeartBeat heartbeat = workerNodeInfoMap.getOrDefault(node, null);
                    Optional<HostWeight> hostWeightOpt = this.getHostWeight(node, workerGroup, heartbeat);
                    hostWeightOpt.ifPresent(hostWeights::add);
                }
                if (hostWeights.isEmpty()) continue;
                workerHostWeights.put(workerGroup, hostWeights);
            }
            this.syncWorkerHostWeight(workerHostWeights);
        }
        catch (Throwable ex) {
            this.logger.error("Sync worker resource error", ex);
        }
    }

    public Optional<HostWeight> getHostWeight(String addr, String workerGroup, WorkerHeartBeat heartBeat) {
        if (heartBeat == null) {
            this.logger.warn("worker {} in work group {} have not received the heartbeat", (Object)addr, (Object)workerGroup);
            return Optional.empty();
        }
        if (1 == heartBeat.getServerStatus()) {
            this.logger.warn("worker {} current cpu load average {} is too high or available memory {}G is too low", new Object[]{addr, heartBeat.getLoadAverage(), heartBeat.getAvailablePhysicalMemorySize()});
            return Optional.empty();
        }
        if (2 == heartBeat.getServerStatus()) {
            this.logger.warn("worker {} is busy, current waiting task count {} is large than worker thread count {}", new Object[]{addr, heartBeat.getWorkerWaitingTaskCount(), heartBeat.getWorkerExecThreadCount()});
            return Optional.empty();
        }
        return Optional.of(new HostWeight(HostWorker.of(addr, heartBeat.getWorkerHostWeight(), workerGroup), heartBeat.getCpuUsage(), heartBeat.getMemoryUsage(), heartBeat.getLoadAverage(), heartBeat.getWorkerWaitingTaskCount(), heartBeat.getStartupTime()));
    }

    private void syncWorkerHostWeight(Map<String, Set<HostWeight>> workerHostWeights) {
        this.lock.lock();
        try {
            this.workerHostWeightsMap.clear();
            this.workerHostWeightsMap.putAll(workerHostWeights);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Set<HostWeight> getWorkerHostWeights(String workerGroup) {
        this.lock.lock();
        try {
            Set<HostWeight> set = this.workerHostWeightsMap.get(workerGroup);
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class WorkerWeightListener
    implements WorkerInfoChangeListener {
        private WorkerWeightListener() {
        }

        @Override
        public void notify(Map<String, Set<String>> workerGroups, Map<String, WorkerHeartBeat> workerNodeInfo) {
            LowerWeightHostManager.this.syncWorkerResources(workerGroups, workerNodeInfo);
        }
    }
}

