/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import io.netty.channel.Channel;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.TaskEventType;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResultCommand;
import org.apache.dolphinscheduler.remote.command.TaskExecuteRunningCommand;
import org.apache.dolphinscheduler.remote.command.TaskRejectCommand;

public class TaskEvent {
    private int taskInstanceId;
    private String workerAddress;
    private TaskExecutionStatus state;
    private Date startTime;
    private Date endTime;
    private String executePath;
    private String logPath;
    private int processId;
    private String appIds;
    private TaskEventType event;
    private String varPool;
    private Channel channel;
    private int processInstanceId;

    public static TaskEvent newDispatchEvent(int processInstanceId, int taskInstanceId, String workerAddress) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(processInstanceId);
        event.setTaskInstanceId(taskInstanceId);
        event.setWorkerAddress(workerAddress);
        event.setEvent(TaskEventType.DISPATCH);
        return event;
    }

    public static TaskEvent newRunningEvent(TaskExecuteRunningCommand command, Channel channel, String workerAddress) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(command.getProcessInstanceId());
        event.setTaskInstanceId(command.getTaskInstanceId());
        event.setState(command.getStatus());
        event.setStartTime(command.getStartTime());
        event.setExecutePath(command.getExecutePath());
        event.setLogPath(command.getLogPath());
        event.setAppIds(command.getAppIds());
        event.setChannel(channel);
        event.setWorkerAddress(workerAddress);
        event.setEvent(TaskEventType.RUNNING);
        return event;
    }

    public static TaskEvent newResultEvent(TaskExecuteResultCommand command, Channel channel, String workerAddress) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(command.getProcessInstanceId());
        event.setTaskInstanceId(command.getTaskInstanceId());
        event.setState(TaskExecutionStatus.of((int)command.getStatus()));
        event.setStartTime(command.getStartTime());
        event.setExecutePath(command.getExecutePath());
        event.setLogPath(command.getLogPath());
        event.setEndTime(command.getEndTime());
        event.setProcessId(command.getProcessId());
        event.setAppIds(command.getAppIds());
        event.setVarPool(command.getVarPool());
        event.setChannel(channel);
        event.setWorkerAddress(workerAddress);
        event.setEvent(TaskEventType.RESULT);
        return event;
    }

    public static TaskEvent newRecallEvent(TaskRejectCommand command, Channel channel) {
        TaskEvent event = new TaskEvent();
        event.setTaskInstanceId(command.getTaskInstanceId());
        event.setProcessInstanceId(command.getProcessInstanceId());
        event.setChannel(channel);
        event.setEvent(TaskEventType.WORKER_REJECT);
        return event;
    }

    @Generated
    public TaskEvent() {
    }

    @Generated
    public int getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @Generated
    public String getWorkerAddress() {
        return this.workerAddress;
    }

    @Generated
    public TaskExecutionStatus getState() {
        return this.state;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getExecutePath() {
        return this.executePath;
    }

    @Generated
    public String getLogPath() {
        return this.logPath;
    }

    @Generated
    public int getProcessId() {
        return this.processId;
    }

    @Generated
    public String getAppIds() {
        return this.appIds;
    }

    @Generated
    public TaskEventType getEvent() {
        return this.event;
    }

    @Generated
    public String getVarPool() {
        return this.varPool;
    }

    @Generated
    public Channel getChannel() {
        return this.channel;
    }

    @Generated
    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public void setTaskInstanceId(int taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    @Generated
    public void setWorkerAddress(String workerAddress) {
        this.workerAddress = workerAddress;
    }

    @Generated
    public void setState(TaskExecutionStatus state) {
        this.state = state;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    @Generated
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Generated
    public void setProcessId(int processId) {
        this.processId = processId;
    }

    @Generated
    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    @Generated
    public void setEvent(TaskEventType event) {
        this.event = event;
    }

    @Generated
    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    @Generated
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Generated
    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskEvent)) {
            return false;
        }
        TaskEvent other = (TaskEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTaskInstanceId() != other.getTaskInstanceId()) {
            return false;
        }
        if (this.getProcessId() != other.getProcessId()) {
            return false;
        }
        if (this.getProcessInstanceId() != other.getProcessInstanceId()) {
            return false;
        }
        String this$workerAddress = this.getWorkerAddress();
        String other$workerAddress = other.getWorkerAddress();
        if (this$workerAddress == null ? other$workerAddress != null : !this$workerAddress.equals(other$workerAddress)) {
            return false;
        }
        TaskExecutionStatus this$state = this.getState();
        TaskExecutionStatus other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$executePath = this.getExecutePath();
        String other$executePath = other.getExecutePath();
        if (this$executePath == null ? other$executePath != null : !this$executePath.equals(other$executePath)) {
            return false;
        }
        String this$logPath = this.getLogPath();
        String other$logPath = other.getLogPath();
        if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
            return false;
        }
        String this$appIds = this.getAppIds();
        String other$appIds = other.getAppIds();
        if (this$appIds == null ? other$appIds != null : !this$appIds.equals(other$appIds)) {
            return false;
        }
        TaskEventType this$event = this.getEvent();
        TaskEventType other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$varPool = this.getVarPool();
        String other$varPool = other.getVarPool();
        if (this$varPool == null ? other$varPool != null : !this$varPool.equals(other$varPool)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTaskInstanceId();
        result = result * 59 + this.getProcessId();
        result = result * 59 + this.getProcessInstanceId();
        String $workerAddress = this.getWorkerAddress();
        result = result * 59 + ($workerAddress == null ? 43 : $workerAddress.hashCode());
        TaskExecutionStatus $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $executePath = this.getExecutePath();
        result = result * 59 + ($executePath == null ? 43 : $executePath.hashCode());
        String $logPath = this.getLogPath();
        result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
        String $appIds = this.getAppIds();
        result = result * 59 + ($appIds == null ? 43 : $appIds.hashCode());
        TaskEventType $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $varPool = this.getVarPool();
        result = result * 59 + ($varPool == null ? 43 : $varPool.hashCode());
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskEvent(taskInstanceId=" + this.getTaskInstanceId() + ", workerAddress=" + this.getWorkerAddress() + ", state=" + this.getState() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", executePath=" + this.getExecutePath() + ", logPath=" + this.getLogPath() + ", processId=" + this.getProcessId() + ", appIds=" + this.getAppIds() + ", event=" + this.getEvent() + ", varPool=" + this.getVarPool() + ", channel=" + this.getChannel() + ", processInstanceId=" + this.getProcessInstanceId() + ")";
    }
}

