/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cache.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.dolphinscheduler.server.master.cache.StreamTaskInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteRunnable;
import org.springframework.stereotype.Component;

@Component
public class StreamTaskInstanceExecCacheManagerImpl
implements StreamTaskInstanceExecCacheManager {
    private final ConcurrentHashMap<Integer, StreamTaskExecuteRunnable> streamTaskInstanceExecMaps = new ConcurrentHashMap();

    @PostConstruct
    public void registerMetrics() {
        TaskMetrics.registerTaskPrepared(this.streamTaskInstanceExecMaps::size);
    }

    @Override
    public StreamTaskExecuteRunnable getByTaskInstanceId(int taskInstanceId) {
        return this.streamTaskInstanceExecMaps.get(taskInstanceId);
    }

    @Override
    public boolean contains(int taskInstanceId) {
        return this.streamTaskInstanceExecMaps.containsKey(taskInstanceId);
    }

    @Override
    public void removeByTaskInstanceId(int taskInstanceId) {
        this.streamTaskInstanceExecMaps.remove(taskInstanceId);
    }

    @Override
    public void cache(int taskInstanceId, @NonNull StreamTaskExecuteRunnable streamTaskExecuteRunnable) {
        if (streamTaskExecuteRunnable == null) {
            throw new NullPointerException("streamTaskExecuteRunnable is marked non-null but is null");
        }
        this.streamTaskInstanceExecMaps.put(taskInstanceId, streamTaskExecuteRunnable);
    }

    @Override
    public Collection<StreamTaskExecuteRunnable> getAll() {
        return ImmutableList.copyOf(this.streamTaskInstanceExecMaps.values());
    }
}

