/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.Optional;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleError;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class TaskStateEventHandler
implements StateEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(TaskStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException, StateEventHandleError {
        TaskStateEvent taskStateEvent = (TaskStateEvent)stateEvent;
        this.measureTaskState(taskStateEvent);
        workflowExecuteRunnable.checkTaskInstanceByStateEvent(taskStateEvent);
        Optional<TaskInstance> taskInstanceOptional = workflowExecuteRunnable.getTaskInstance(taskStateEvent.getTaskInstanceId());
        TaskInstance task = taskInstanceOptional.orElseThrow(() -> new StateEventHandleError("Cannot find task instance from taskMap by task instance id: " + taskStateEvent.getTaskInstanceId()));
        if (task.getState() == null) {
            throw new StateEventHandleError("Task state event handle error due to task state is null");
        }
        logger.info("Handle task instance state event, the current task instance state {} will be changed to {}", (Object)task.getState(), (Object)taskStateEvent.getStatus());
        Map<Long, Integer> completeTaskMap = workflowExecuteRunnable.getCompleteTaskMap();
        if (task.getState().isFinished() && taskStateEvent.getStatus() != null && taskStateEvent.getStatus().isRunning()) {
            String errorMessage = String.format("The current task instance state is %s, but the task state event status is %s, so the task state event will be ignored", task.getState(), taskStateEvent.getStatus());
            logger.warn(errorMessage);
            throw new StateEventHandleError(errorMessage);
        }
        if (task.getState().isFinished()) {
            if (completeTaskMap.containsKey(task.getTaskCode()) && completeTaskMap.get(task.getTaskCode()).equals(task.getId())) {
                logger.warn("The task instance is already complete, stateEvent: {}", (Object)stateEvent);
                return true;
            }
            workflowExecuteRunnable.taskFinished(task);
            if (task.getTaskGroupId() > 0) {
                logger.info("The task instance need to release task Group: {}", (Object)task.getTaskGroupId());
                workflowExecuteRunnable.releaseTaskGroup(task);
            }
            return true;
        }
        Map<Long, ITaskProcessor> activeTaskProcessMap = workflowExecuteRunnable.getActiveTaskProcessMap();
        if (activeTaskProcessMap.containsKey(task.getTaskCode())) {
            ITaskProcessor iTaskProcessor = activeTaskProcessMap.get(task.getTaskCode());
            iTaskProcessor.action(TaskAction.RUN);
            if (iTaskProcessor.taskInstance().getState().isFinished()) {
                if (iTaskProcessor.taskInstance().getState() != task.getState()) {
                    task.setState(iTaskProcessor.taskInstance().getState());
                    task.setEndTime(iTaskProcessor.taskInstance().getEndTime());
                }
                workflowExecuteRunnable.taskFinished(task);
            }
            return true;
        }
        throw new StateEventHandleError("Task state event handle error, due to the task is not in activeTaskProcessorMaps");
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.TASK_STATE_CHANGE;
    }

    private void measureTaskState(TaskStateEvent taskStateEvent) {
        if (taskStateEvent == null || taskStateEvent.getStatus() == null) {
            logger.warn("The task event is broken..., taskEvent: {}", (Object)taskStateEvent);
            return;
        }
        if (taskStateEvent.getStatus().isFinished()) {
            TaskMetrics.incTaskInstanceByState("finish");
        }
        switch (taskStateEvent.getStatus()) {
            case KILL: {
                TaskMetrics.incTaskInstanceByState("stop");
                break;
            }
            case SUCCESS: {
                TaskMetrics.incTaskInstanceByState("success");
                break;
            }
            case FAILURE: {
                TaskMetrics.incTaskInstanceByState("fail");
                break;
            }
        }
    }
}

