/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class WorkflowSubmitFailStateEventHandler
implements StateEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowSubmitFailStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException {
        WorkflowStateEvent workflowStateEvent = (WorkflowStateEvent)stateEvent;
        ProcessInstance processInstance = workflowExecuteRunnable.getProcessInstance();
        this.measureProcessState(workflowStateEvent);
        log.info("Handle workflow instance submit fail state event, the current workflow instance state {} will be changed to {}", (Object)processInstance.getState(), (Object)workflowStateEvent.getStatus());
        workflowExecuteRunnable.updateProcessInstanceState(workflowStateEvent);
        workflowExecuteRunnable.endProcess();
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.PROCESS_SUBMIT_FAILED;
    }

    private void measureProcessState(WorkflowStateEvent processStateEvent) {
        if (processStateEvent.getStatus().isFinished()) {
            ProcessInstanceMetrics.incProcessInstanceByState("finish");
        }
        switch (processStateEvent.getStatus()) {
            case STOP: {
                ProcessInstanceMetrics.incProcessInstanceByState("stop");
                break;
            }
            case SUCCESS: {
                ProcessInstanceMetrics.incProcessInstanceByState("success");
                break;
            }
            case FAILURE: {
                ProcessInstanceMetrics.incProcessInstanceByState("fail");
                break;
            }
        }
    }
}

