/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResultCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteResponseProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteResponseProcessor.class);
    @Autowired
    private TaskEventService taskEventService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_RESULT == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteResultCommand taskExecuteResultMessage = (TaskExecuteResultCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskExecuteResultCommand.class);
        TaskEvent taskResultEvent = TaskEvent.newResultEvent(taskExecuteResultMessage, channel, taskExecuteResultMessage.getMessageSenderAddress());
        try {
            LoggerUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskResultEvent.getProcessInstanceId(), (Integer)taskResultEvent.getTaskInstanceId());
            this.logger.info("Received task execute result, event: {}", (Object)taskResultEvent);
            this.taskEventService.addEvent(taskResultEvent);
        }
        finally {
            LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

