/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.cache.StreamTaskInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteThreadPool;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventExecuteService
extends BaseDaemonThread {
    private static final Logger logger = LoggerFactory.getLogger(EventExecuteService.class);
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StreamTaskInstanceExecCacheManager streamTaskInstanceExecCacheManager;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;
    @Autowired
    private StreamTaskExecuteThreadPool streamTaskExecuteThreadPool;

    protected EventExecuteService() {
        super("EventServiceStarted");
    }

    public synchronized void start() {
        logger.info("Master Event execute service starting");
        super.start();
        logger.info("Master Event execute service started");
    }

    public void run() {
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                this.workflowEventHandler();
                this.streamTaskEventHandler();
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                logger.warn("Master event service interrupted, will exit this loop", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                logger.error("Master event execute service error", (Throwable)e);
            }
        }
    }

    private void workflowEventHandler() {
        for (WorkflowExecuteRunnable workflowExecuteThread : this.processInstanceExecCacheManager.getAll()) {
            try {
                LoggerUtils.setWorkflowInstanceIdMDC((Integer)workflowExecuteThread.getProcessInstance().getId());
                this.workflowExecuteThreadPool.executeEvent(workflowExecuteThread);
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }

    private void streamTaskEventHandler() {
        for (StreamTaskExecuteRunnable streamTaskExecuteRunnable : this.streamTaskInstanceExecCacheManager.getAll()) {
            try {
                LoggerUtils.setTaskInstanceIdMDC((Integer)streamTaskExecuteRunnable.getTaskInstance().getId());
                this.streamTaskExecuteThreadPool.executeEvent(streamTaskExecuteRunnable);
            }
            finally {
                LoggerUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }
}

