/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchTaskUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchTaskUtils.class);
    private static ScriptEngineManager manager = new ScriptEngineManager();
    private static ScriptEngine engine = manager.getEngineByName("js");
    private static final String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";

    public static boolean evaluate(String expression) throws ScriptException {
        Object result = engine.eval(expression);
        return (Boolean)result;
    }

    public static String generateContentWithTaskParams(String condition, Map<String, Property> globalParams, Map<String, Property> varParams) {
        String content = condition.replaceAll("'", "\"");
        if (MapUtils.isEmpty(globalParams) && MapUtils.isEmpty(varParams)) {
            throw new IllegalArgumentException("globalParams and varParams are both empty, please check it.");
        }
        HashMap params = Maps.newHashMap();
        if (MapUtils.isNotEmpty(globalParams)) {
            params.putAll(globalParams);
        }
        if (MapUtils.isNotEmpty(varParams)) {
            params.putAll(varParams);
        }
        String originContent = content;
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        while (m.find()) {
            String paramName = m.group(1);
            Property property = (Property)params.get(paramName);
            if (property == null) continue;
            String value = ParameterUtils.isNumber((Property)property) || ParameterUtils.isBoolean((Property)property) ? "" + ParameterUtils.getParameterValue((Property)property) : "\"" + ParameterUtils.getParameterValue((Property)property) + "\"";
            log.info("paramName:{}\uff0cparamValue:{}", (Object)paramName, (Object)value);
            content = content.replace("${" + paramName + "}", value);
        }
        if (originContent.equals(content)) {
            throw new IllegalArgumentException("condition is not valid, please check it. condition: " + condition);
        }
        return content;
    }
}

