/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.builder;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.DataQualityTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionContextBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionContextBuilder.class);
    private TaskExecutionContext taskExecutionContext = new TaskExecutionContext();

    public static TaskExecutionContextBuilder get() {
        return new TaskExecutionContextBuilder();
    }

    public TaskExecutionContextBuilder buildTaskInstanceRelatedInfo(TaskInstance taskInstance) {
        this.taskExecutionContext.setTaskInstanceId(taskInstance.getId().intValue());
        this.taskExecutionContext.setTaskName(taskInstance.getName());
        this.taskExecutionContext.setFirstSubmitTime(DateUtils.dateToTimeStamp((Date)taskInstance.getFirstSubmitTime()));
        this.taskExecutionContext.setStartTime(DateUtils.dateToTimeStamp((Date)taskInstance.getStartTime()));
        this.taskExecutionContext.setTaskType(taskInstance.getTaskType());
        this.taskExecutionContext.setLogPath(taskInstance.getLogPath());
        this.taskExecutionContext.setWorkerGroup(taskInstance.getWorkerGroup());
        this.taskExecutionContext.setEnvironmentConfig(taskInstance.getEnvironmentConfig());
        this.taskExecutionContext.setHost(taskInstance.getHost());
        this.taskExecutionContext.setResources(taskInstance.getResources());
        this.taskExecutionContext.setDelayTime(taskInstance.getDelayTime());
        this.taskExecutionContext.setVarPool(taskInstance.getVarPool());
        this.taskExecutionContext.setDryRun(taskInstance.getDryRun());
        this.taskExecutionContext.setTestFlag(taskInstance.getTestFlag());
        this.taskExecutionContext.setCurrentExecutionStatus(TaskExecutionStatus.SUBMITTED_SUCCESS);
        this.taskExecutionContext.setCpuQuota(taskInstance.getCpuQuota());
        this.taskExecutionContext.setMemoryMax(taskInstance.getMemoryMax());
        this.taskExecutionContext.setAppIds(taskInstance.getAppLink());
        return this;
    }

    public TaskExecutionContextBuilder buildTaskDefinitionRelatedInfo(TaskDefinition taskDefinition) {
        this.taskExecutionContext.setTaskTimeout(Integer.MAX_VALUE);
        if (taskDefinition.getTimeoutFlag() == TimeoutFlag.OPEN) {
            this.taskExecutionContext.setTaskTimeoutStrategy(taskDefinition.getTimeoutNotifyStrategy());
            if (taskDefinition.getTimeoutNotifyStrategy() == TaskTimeoutStrategy.FAILED || taskDefinition.getTimeoutNotifyStrategy() == TaskTimeoutStrategy.WARNFAILED) {
                this.taskExecutionContext.setTaskTimeout(Math.min(taskDefinition.getTimeout() * 60, Integer.MAX_VALUE));
            }
        }
        this.taskExecutionContext.setTaskParams(taskDefinition.getTaskParams());
        return this;
    }

    public TaskExecutionContextBuilder buildProcessInstanceRelatedInfo(ProcessInstance processInstance) {
        this.taskExecutionContext.setProcessInstanceId(processInstance.getId().intValue());
        this.taskExecutionContext.setScheduleTime(DateUtils.dateToTimeStamp((Date)processInstance.getScheduleTime()));
        this.taskExecutionContext.setGlobalParams(processInstance.getGlobalParams());
        this.taskExecutionContext.setExecutorId(processInstance.getExecutorId());
        this.taskExecutionContext.setCmdTypeIfComplement(processInstance.getCmdTypeIfComplement().getCode());
        this.taskExecutionContext.setTenantCode(processInstance.getTenantCode());
        return this;
    }

    public TaskExecutionContextBuilder buildProcessDefinitionRelatedInfo(ProcessDefinition processDefinition) {
        this.taskExecutionContext.setProcessDefineCode(Long.valueOf(processDefinition.getCode()));
        this.taskExecutionContext.setProcessDefineVersion(processDefinition.getVersion());
        this.taskExecutionContext.setProjectCode(processDefinition.getProjectCode());
        return this;
    }

    public TaskExecutionContextBuilder buildDataQualityTaskExecutionContext(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        this.taskExecutionContext.setDataQualityTaskExecutionContext(dataQualityTaskExecutionContext);
        return this;
    }

    public TaskExecutionContextBuilder buildResourceParametersInfo(ResourceParametersHelper parametersHelper) {
        this.taskExecutionContext.setResourceParametersHelper(parametersHelper);
        return this;
    }

    public TaskExecutionContextBuilder buildK8sTaskRelatedInfo(K8sTaskExecutionContext k8sTaskExecutionContext) {
        this.taskExecutionContext.setK8sTaskExecutionContext(k8sTaskExecutionContext);
        return this;
    }

    public TaskExecutionContextBuilder buildParamInfo(Map<String, Property> propertyMap) {
        this.taskExecutionContext.setPrepareParamsMap(propertyMap);
        return this;
    }

    public TaskExecutionContextBuilder buildBusinessParamsMap(Map<String, Property> businessParamsMap) {
        this.taskExecutionContext.setParamsMap(businessParamsMap);
        return this;
    }

    public TaskExecutionContextBuilder buildWorkflowInstanceHost(String masterHost) {
        this.taskExecutionContext.setWorkflowInstanceHost(masterHost);
        return this;
    }

    public TaskExecutionContext create() {
        Preconditions.checkNotNull((Object)this.taskExecutionContext.getWorkflowInstanceHost(), (Object)"The workflow instance host cannot be empty");
        return this.taskExecutionContext;
    }
}

