/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.AbstractSelector;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWeight;
import org.springframework.util.CollectionUtils;

public class LowerWeightRoundRobin
extends AbstractSelector<HostWeight> {
    @Override
    public HostWeight doSelect(Collection<HostWeight> sources) {
        double totalWeight = 0.0;
        double lowWeight = 0.0;
        HostWeight lowerNode = null;
        List<HostWeight> weights = this.canAssignTaskHost(sources);
        for (HostWeight hostWeight : weights) {
            totalWeight += hostWeight.getWeight();
            hostWeight.setCurrentWeight(hostWeight.getCurrentWeight() + hostWeight.getWeight());
            if (lowerNode != null && !(lowWeight > hostWeight.getCurrentWeight())) continue;
            lowerNode = hostWeight;
            lowWeight = hostWeight.getCurrentWeight();
        }
        if (lowerNode != null) {
            lowerNode.setCurrentWeight(lowerNode.getCurrentWeight() + totalWeight);
        }
        return lowerNode;
    }

    private List<HostWeight> canAssignTaskHost(Collection<HostWeight> sources) {
        if (CollectionUtils.isEmpty(sources)) {
            return Collections.emptyList();
        }
        List<HostWeight> zeroWaitingTask = sources.stream().filter(h -> h.getWaitingTaskCount() == 0).collect(Collectors.toList());
        if (!zeroWaitingTask.isEmpty()) {
            return zeroWaitingTask;
        }
        HostWeight hostWeight = sources.stream().min(Comparator.comparing(HostWeight::getWaitingTaskCount)).get();
        ArrayList waitingTask = Lists.newArrayList((Object[])new HostWeight[]{hostWeight});
        List equalWaitingTask = sources.stream().filter(h -> !h.getHost().equals((Object)hostWeight.getHost()) && h.getWaitingTaskCount() == hostWeight.getWaitingTaskCount()).collect(Collectors.toList());
        if (!equalWaitingTask.isEmpty()) {
            waitingTask.addAll(equalWaitingTask);
        }
        return waitingTask;
    }
}

